/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPartCollector;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.Model.BabyPose;
import moe.plushie.armourers_workshop.core.client.model.CachedModel;
import moe.plushie.armourers_workshop.utils.ModelPartHolder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelHolder {
    private static final HashMap<Class<?>, Entry<?, ?>> ENTRIES = new HashMap();

    public static <V extends Model, M extends IModel> M ofNullable(V model) {
        if (model != null) {
            return ModelHolder.of(model);
        }
        return null;
    }

    public static <M extends IModel> M of(Model model) {
        IAssociatedObjectProvider provider = ObjectUtils.safeCast(model, IAssociatedObjectProvider.class);
        if (provider != null) {
            IModel holder = (IModel)provider.getAssociatedObject();
            if (holder != null) {
                return (M)holder;
            }
            holder = ModelHolder.createHolder(model);
            provider.setAssociatedObject(holder);
            return (M)holder;
        }
        return ModelHolder.createHolder(model);
    }

    public static <T extends Model> void register(Class<T> clazz, Map<String, String> mapper) {
        ENTRIES.put(clazz, new Entry(clazz, null, mapper));
    }

    private static <V extends Model, M extends IModel> M createHolder(V model) {
        HashSet<Entry<V, M>> exists = new HashSet<Entry<V, M>>();
        ArrayList<Map> builders = new ArrayList<Map>();
        Function factory = null;
        for (Class<?> clazz = model.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Entry<V, M> entry = ModelHolder.getEntry(clazz);
            if (entry == null || !exists.add(entry)) continue;
            builders.add(entry.mapper);
            if (factory != null) continue;
            factory = entry.factory;
        }
        if (factory == null) {
            Function<Container, CachedModel> factory1 = CachedModel::new;
            factory = (Function)ObjectUtils.unsafeCast(factory1);
        }
        Container container = new Container(model);
        Map<String, ModelPart> allParts = ModelHolder.parseModel(model);
        builders.forEach(mapper -> mapper.forEach((target, source) -> {
            ModelPart part = (ModelPart)allParts.remove(source);
            if (part != null) {
                container.put((String)target, part);
            }
        }));
        allParts.forEach((key, part) -> {
            if (!key.contains(".")) {
                container.unnamed(Collections.singleton(part));
            }
        });
        return (M)((IModel)factory.apply(container));
    }

    private static <V extends Model, M extends IModel> Entry<V, M> getEntry(Class<?> clazz) {
        Entry<Object, Object> entry = ENTRIES.get(clazz);
        if (entry == null) {
            if (clazz == Object.class) {
                return null;
            }
            entry = ModelHolder.getEntry(clazz.getSuperclass());
            ENTRIES.put(clazz, entry);
        }
        return (Entry)ObjectUtils.unsafeCast(entry);
    }

    private static Map<String, ModelPart> parseModel(Model model) {
        LinkedHashMap<String, ModelPart> allParts = new LinkedHashMap<String, ModelPart>();
        if (model instanceof IModelPartCollector) {
            IModelPartCollector provider = (IModelPartCollector)model;
            provider.aw2$collect(allParts);
        }
        return allParts;
    }

    public static class Entry<T extends Model, M extends IModel> {
        Class<T> clazz;
        Function<Container, M> factory;
        Map<String, String> mapper;

        Entry(Class<T> clazz, Function<Container, M> factory, Map<String, String> mapper) {
            this.clazz = clazz;
            this.factory = factory;
            this.mapper = mapper;
        }
    }

    public static class Container
    extends CachedModel.Container<ModelPart> {
        private final EntityModel<?> model;

        public Container(Model model) {
            super(model.getClass(), ModelPartHolder::of);
            this.model = ObjectUtils.safeCast(model, EntityModel.class);
            this.babyPose = BabyPose.getBabyPose(model);
        }

        @Override
        public IModelBabyPose getBabyPose() {
            if (this.model != null && this.model.f_102610_) {
                return super.getBabyPose();
            }
            return null;
        }
    }
}

