/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.api.data.IDataSerializerProvider;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class NonNullItemList
extends NonNullList<ItemStack>
implements IDataSerializerProvider {
    private static final Codec<Pair<Byte, ItemStack>> CODEC = Codec.pair((Codec)DataTypeCodecs.BYTE.fieldOf("Slot").codec(), DataTypeCodecs.ITEM_STACK);
    private static final DataSerializerKey<List<Pair<Byte, ItemStack>>> SERIALIZER_KEY = DataSerializerKey.create("Items", CODEC.listOf(), Collections.emptyList());

    public NonNullItemList(int size) {
        super(NonNullItemList.buildDefaultList(size), (Object)ItemStack.f_41583_);
    }

    private static List<ItemStack> buildDefaultList(int size) {
        Object[] objects = new ItemStack[size];
        Arrays.fill(objects, ItemStack.f_41583_);
        return Arrays.asList(objects);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        int size = this.size();
        ArrayList<Pair> values = new ArrayList<Pair>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = (ItemStack)this.get(i);
            if (itemStack.m_41619_()) continue;
            values.add(Pair.of((Object)((byte)i), (Object)((ItemStack)this.get(i))));
        }
        serializer.write(SERIALIZER_KEY, values);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        int size = this.size();
        List<Pair<Byte, ItemStack>> values = serializer.read(SERIALIZER_KEY);
        for (Pair<Byte, ItemStack> pair : values) {
            int slot = (Byte)pair.getFirst() & 0xFF;
            if (slot >= size) continue;
            this.set(slot, (ItemStack)pair.getSecond());
        }
    }
}

