/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.TagParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SkinFileUtils {
    public static String normalize(String filename) {
        return FilenameUtils.normalize((String)filename);
    }

    public static String normalize(String filename, boolean unixSeparator) {
        return FilenameUtils.normalize((String)filename, (boolean)unixSeparator);
    }

    public static String normalizeNoEndSeparator(String filename, boolean unixSeparator) {
        return FilenameUtils.normalizeNoEndSeparator((String)filename, (boolean)unixSeparator);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        return FilenameUtils.concat((String)basePath, (String)fullFilenameToAdd);
    }

    public static List<File> listFiles(File directory) {
        try {
            Object[] files = directory.listFiles();
            if (files != null) {
                return Lists.newArrayList((Object[])files);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<File> listAllFiles(File directory) {
        ArrayList<File> allFiles = new ArrayList<File>();
        allFiles.add(directory);
        for (int i = 0; i < allFiles.size(); ++i) {
            File path = (File)allFiles.get(i);
            if (!path.isDirectory()) continue;
            allFiles.addAll(SkinFileUtils.listFiles(path));
        }
        allFiles.remove(0);
        return allFiles;
    }

    public static String getBaseName(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static String removeExtension(String filename) {
        return FilenameUtils.removeExtension((String)filename);
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static String getRelativePath(String path, String rootPath) {
        if (path.equals(rootPath)) {
            return "/";
        }
        if (path.startsWith(rootPath)) {
            return path.substring(rootPath.length());
        }
        return path;
    }

    public static String getRelativePath(String path, String rootPath, boolean unixSeparator) {
        return SkinFileUtils.normalize(SkinFileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static String getRelativePath(File path, File rootPath) {
        return SkinFileUtils.getRelativePath(path.getAbsolutePath(), rootPath.getAbsolutePath());
    }

    public static String getRelativePath(File path, File rootPath, boolean unixSeparator) {
        return SkinFileUtils.normalize(SkinFileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static void forceMkdir(File directory) throws IOException {
        FileUtils.forceMkdir((File)directory);
    }

    public static void forceMkdirParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            SkinFileUtils.forceMkdir(parent);
        }
    }

    public static boolean deleteQuietly(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public static byte[] readStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5120);
        SkinFileUtils.transferTo(inputStream, outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return outputStream.toByteArray();
    }

    public static void copyInputStreamToFile(InputStream inputStream, File destination) throws IOException {
        int bytesRead;
        SkinFileUtils.forceMkdirParent(destination);
        FileOutputStream outputStream = new FileOutputStream(destination);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void transferTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void writeNBT(CompoundTag compoundTag, File file) throws IOException {
        SkinFileUtils.writeNBT(compoundTag, new FileOutputStream(file));
    }

    public static void writeNBT(CompoundTag compoundTag, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            NbtIo.m_128941_((CompoundTag)compoundTag, (DataOutput)dataOutputStream);
        }
    }

    public static CompoundTag readNBT(File file) throws IOException {
        if (file.exists()) {
            return SkinFileUtils.readNBT(new FileInputStream(file));
        }
        return null;
    }

    public static CompoundTag readNBT(InputStream inputStream) throws IOException {
        try (DataInputStream datainputstream = new DataInputStream(inputStream);){
            CompoundTag compoundTag = NbtIo.m_128928_((DataInput)datainputstream);
            return compoundTag;
        }
    }

    public static CompoundTag readNBT(String contents) {
        try {
            return TagParser.m_129359_((String)contents);
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }

    public static String dumpTree(Skin skin) {
        StringBuilder tree = new StringBuilder();
        tree.append("<Skin ");
        tree.append("name=").append(skin.getCustomName()).append(",");
        tree.append("author=").append(skin.getAuthorName()).append(",");
        tree.append("type=").append(skin.getType().getRegistryName().getPath());
        tree.append(">\n");
        for (SkinPart part : skin.getParts()) {
            String prefix = "|-- ";
            String subtree = SkinFileUtils.dumpTree(part);
            for (String line : subtree.split("\n")) {
                tree.append(prefix).append(line).append("\n");
                prefix = "| ";
            }
        }
        return tree.toString();
    }

    private static String dumpTree(SkinPart part) {
        StringBuilder tree = new StringBuilder();
        tree.append("<SkinPart ");
        tree.append("name=").append(ObjectUtils.orElse(part.getName(), "")).append(",");
        tree.append("type=").append(part.getType().getRegistryName().getPath());
        tree.append(">\n");
        for (SkinPart childPart : part.getParts()) {
            String prefix = "|-- ";
            String subtree = SkinFileUtils.dumpTree(childPart);
            for (String line : subtree.split("\n")) {
                tree.append(prefix).append(line).append("\n");
                prefix = "| ";
            }
        }
        SkinCubes data = part.getCubeData();
        int count = data.getCubeTotal();
        for (int i = 0; i < count; ++i) {
            SkinCube cube = data.getCube(i);
            tree.append("<SkinCube ").append("rect=").append(cube.getShape()).append(",").append("type=").append(cube.getType().getRegistryName().getPath()).append(">\n");
        }
        return tree.toString();
    }
}

