/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.player.AbstractClientPlayer.ABI;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.texture.PlayerTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ext.OpenResourceLocation;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class TextureUtils {
    public static IResourceLocation registerTexture(String key, DynamicTexture texture) {
        ResourceLocation location = Minecraft.m_91087_().m_91097_().m_118490_(key, texture);
        return OpenResourceLocation.create(location);
    }

    public static IResourceLocation getTexture(Entity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            ResourceLocation location = ABI.getSkin(player).texture();
            return OpenResourceLocation.create(location);
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    public static IResourceLocation getPlayerTextureLocation(PlayerTextureDescriptor descriptor) {
        PlayerTexture bakedTexture = PlayerTextureLoader.getInstance().loadTexture(descriptor);
        if (bakedTexture != null && bakedTexture.isDownloaded()) {
            return bakedTexture.getLocation();
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    @Nullable
    public static BakedEntityTexture getPlayerTextureModel(PlayerTextureDescriptor descriptor) {
        IResourceLocation texture = TextureUtils.getPlayerTextureLocation(descriptor);
        if (texture != null) {
            return PlayerTextureLoader.getInstance().getTextureModel(texture);
        }
        return null;
    }

    public static IPaintColor getPlayerTextureModelColor(PlayerTextureDescriptor descriptor, TexturePos texturePos) {
        BakedEntityTexture textureModel = TextureUtils.getPlayerTextureModel(descriptor);
        if (textureModel != null) {
            return textureModel.getColor(texturePos);
        }
        return null;
    }

    public static NativeImage readTextureImage(ByteBuffer buffer) {
        try {
            return NativeImage.m_85062_((ByteBuffer)buffer.asReadOnlyBuffer());
        }
        catch (IOException e) {
            return new NativeImage(NativeImage.Format.RGBA, 128, 128, false);
        }
    }
}

