/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface TypedEventRegistry<E> {
    public static <E> TypedEventRegistry<E> factory(Supplier<E> factory) {
        return TypedEventRegistry.factory(null, factory);
    }

    public static <E> TypedEventRegistry<E> factory(Class<E> type, final Supplier<E> factory) {
        return new TypedEventRegistry<E>(){

            @Override
            public void observer(Consumer<E> handler) {
                handler.accept(factory.get());
            }

            @Override
            public <T> void observer(Consumer<T> handler, Function<E, T> transform) {
                handler.accept(transform.apply(factory.get()));
            }
        };
    }

    public void observer(Consumer<E> var1);

    public <T> void observer(Consumer<T> var1, Function<E, T> var2);

    default public <O> TypedEventRegistry<O> map(final Function<E, O> transformer) {
        final TypedEventRegistry registry = this;
        return new TypedEventRegistry<O>(){

            @Override
            public void observer(Consumer<O> handler) {
                registry.observer((E event) -> handler.accept(transformer.apply(event)));
            }

            @Override
            public <T> void observer(Consumer<T> handler, Function<O, T> transform) {
                registry.observer(handler, (E event) -> transform.apply(transformer.apply(event)));
            }
        };
    }

    default public <O> TypedEventRegistry<O> flatMap(final Function<E, O> transformer) {
        final TypedEventRegistry registry = this;
        return new TypedEventRegistry<O>(){

            @Override
            public void observer(Consumer<O> handler) {
                registry.observer((E event) -> {
                    Object value = transformer.apply(event);
                    if (value != null) {
                        handler.accept(value);
                    }
                });
            }

            @Override
            public <T> void observer(Consumer<T> handler, Function<O, T> transform) {
                registry.observer((T event) -> {
                    if (event != null) {
                        handler.accept(event);
                    }
                }, (E event) -> {
                    Object value = transformer.apply(event);
                    if (value != null) {
                        return transform.apply(value);
                    }
                    return null;
                });
            }
        };
    }
}

