/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.registry.IRegistry;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.ext.OpenResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class TypedRegistry<T>
implements IRegistry<T> {
    private static final ArrayList<TypedRegistry<?>> INSTANCES = new ArrayList();
    private final Class<?> type;
    private final ArrayList<IRegistryHolder<? extends T>> entries = new ArrayList();
    private final String typeName;
    private final KeyProvider<T> keyProvider;
    private final ValueProvider<T> valueProvider;
    private final RegisterProvider<T> registerProvider;

    public TypedRegistry(String name, Class<?> type, KeyProvider<T> keyProvider, ValueProvider<T> valueProvider, RegisterProvider<T> registerProvider) {
        this.type = type;
        this.typeName = name;
        this.keyProvider = keyProvider;
        this.valueProvider = valueProvider;
        this.registerProvider = registerProvider;
        INSTANCES.add(this);
    }

    public static <T> TypedRegistry<T> create(String name, Class<?> type, final Registry<T> registry) {
        return TypedRegistry.create(name, type, arg_0 -> registry.m_7981_(arg_0), arg_0 -> registry.m_7745_(arg_0), new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(IResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                Registry.m_122965_((Registry)registry, (ResourceLocation)registryName.toLocation(), value);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> create(String name, Class<?> type, Function<T, ResourceLocation> keyProvider, Function<ResourceLocation, T> valueProvider, RegisterProvider<T> registerProvider) {
        KeyProvider keyProvider1 = value -> ObjectUtils.flatMap((ResourceLocation)keyProvider.apply(value), OpenResourceLocation::create);
        ValueProvider valueProvider1 = key -> valueProvider.apply(key.toLocation());
        return new TypedRegistry<T>(name, type, keyProvider1, valueProvider1, registerProvider);
    }

    public static <T> TypedRegistry<T> factory(String name, Class<? extends T> type, final Function<IResourceLocation, T> factory) {
        return TypedRegistry.factory(name, type, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(IResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = factory.apply(registryName);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> factory(String name, Class<?> type, RegisterProvider<T> registerProvider) {
        return new TypedRegistry<T>(name, type, null, null, registerProvider);
    }

    public static <T> TypedRegistry<T> map(String name, Class<? extends T> type, final BiConsumer<IResourceLocation, T> consumer) {
        return new TypedRegistry<T>(name, type, null, null, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(IResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                consumer.accept(registryName, value);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> passthrough(String name, Class<?> type) {
        return new TypedRegistry<T>(name, type, null, null, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(IResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                return () -> value;
            }
        });
    }

    public static <T> IResourceLocation findKey(T value) {
        for (TypedRegistry<?> registry : INSTANCES) {
            if (!registry.getType().isInstance(value)) continue;
            TypedRegistry registry1 = (TypedRegistry)ObjectUtils.unsafeCast(registry);
            return registry1.getKey(value);
        }
        return OpenResourceLocation.create("minecraft", "air");
    }

    public static <T> Collection<IRegistryHolder<? extends T>> findEntries(Class<T> clazz) {
        for (TypedRegistry<?> registry : INSTANCES) {
            if (!clazz.isAssignableFrom(registry.getType())) continue;
            TypedRegistry registry1 = (TypedRegistry)ObjectUtils.unsafeCast(registry);
            return registry1.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public <I extends T> IRegistryHolder<I> register(String name, Supplier<? extends I> provider) {
        OpenResourceLocation registryName = ModConstants.key(name);
        Supplier<? extends I> object = this.registerProvider.register(registryName, provider);
        Entry<? extends I> entry = Entry.of(registryName, object);
        this.entries.add(entry);
        ModLog.debug("Registering {} '{}'", this.typeName, registryName);
        return entry;
    }

    @Override
    public T getValue(IResourceLocation registryName) {
        return (T)this.valueProvider.apply(registryName);
    }

    @Override
    public IResourceLocation getKey(T object) {
        return (IResourceLocation)this.keyProvider.apply(object);
    }

    @Override
    public ArrayList<IRegistryHolder<? extends T>> getEntries() {
        return this.entries;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public static interface KeyProvider<T>
    extends Function<T, IResourceLocation> {
    }

    public static interface ValueProvider<T>
    extends Function<IResourceLocation, T> {
    }

    public static interface RegisterProvider<T> {
        public <I extends T> Supplier<I> register(IResourceLocation var1, Supplier<? extends I> var2);
    }

    public static class Entry<T>
    implements IRegistryHolder<T> {
        private final Supplier<T> value;
        private final IResourceLocation registryName;

        public Entry(IResourceLocation registryName, Supplier<T> value) {
            this.value = value;
            this.registryName = registryName;
        }

        public static <T> Entry<T> of(IResourceLocation registryName, Supplier<T> value) {
            return new Entry<T>(registryName, value);
        }

        public static <T extends S, S> Entry<T> cast(IResourceLocation registryName, Supplier<S> value) {
            Supplier targetValue = (Supplier)ObjectUtils.unsafeCast(value);
            return new Entry<T>(registryName, targetValue);
        }

        public static <T> Entry<T> ofValue(IResourceLocation registryName, T value) {
            return Entry.of(registryName, () -> value);
        }

        public static <T extends S, S> Entry<T> castValue(IResourceLocation registryName, S value) {
            return Entry.cast(registryName, () -> value);
        }

        @Override
        public IResourceLocation getRegistryName() {
            return this.registryName;
        }

        @Override
        public T get() {
            return this.value.get();
        }
    }
}

