/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;

public class OpenMatrix3f
implements IMatrix3f {
    private static final OpenMatrix3f IDENTITY = OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    public float m20;
    public float m21;
    public float m22;

    public OpenMatrix3f() {
    }

    public OpenMatrix3f(IMatrix3f matrix) {
        ObjectUtils.set(matrix, this);
    }

    public OpenMatrix3f(IMatrix4f matrix) {
        FloatBuffer buffer = ObjectUtils.createFloatBuffer(16);
        matrix.store(buffer);
        this.import44(buffer);
    }

    public OpenMatrix3f(IQuaternionf quaternion) {
        this.set(quaternion);
    }

    public OpenMatrix3f(FloatBuffer buffer) {
        if (buffer.remaining() == 9) {
            this.load(buffer);
        } else {
            this.import44(buffer);
        }
    }

    public static OpenMatrix3f createScaleMatrix(float x, float y, float z) {
        OpenMatrix3f matrix = new OpenMatrix3f();
        matrix.m00 = x;
        matrix.m11 = y;
        matrix.m22 = z;
        return matrix;
    }

    public static OpenMatrix3f identity() {
        return IDENTITY;
    }

    public static OpenMatrix3f of(IMatrix3f mat) {
        if (mat instanceof OpenMatrix3f) {
            OpenMatrix3f that = (OpenMatrix3f)mat;
            return that;
        }
        return new OpenMatrix3f(mat);
    }

    public static OpenMatrix3f of(IMatrix4f mat) {
        return new OpenMatrix3f(mat);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.multiply(OpenMatrix3f.createScaleMatrix(x, y, z));
    }

    @Override
    public void rotate(IQuaternionf other) {
        this.multiply(FastLocal.fromRot(other));
    }

    @Override
    public void set(IMatrix3f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public void set(IQuaternionf quaternion) {
        float f = quaternion.x();
        float g = quaternion.y();
        float h = quaternion.z();
        float i = quaternion.w();
        float j = 2.0f * f * f;
        float k = 2.0f * g * g;
        float l = 2.0f * h * h;
        this.m00 = 1.0f - k - l;
        this.m11 = 1.0f - l - j;
        this.m22 = 1.0f - j - k;
        float m = f * g;
        float n = g * h;
        float o = h * f;
        float p = f * i;
        float q = g * i;
        float r = h * i;
        this.m10 = 2.0f * (m + r);
        this.m01 = 2.0f * (m - r);
        this.m20 = 2.0f * (o - q);
        this.m02 = 2.0f * (o + q);
        this.m21 = 2.0f * (n + p);
        this.m12 = 2.0f * (n - p);
    }

    @Override
    public void multiply(float[] values) {
        float x = values[0];
        float y = values[1];
        float z = values[2];
        values[0] = this.m00 * x + this.m01 * y + this.m02 * z;
        values[1] = this.m10 * x + this.m11 * y + this.m12 * z;
        values[2] = this.m20 * x + this.m21 * y + this.m22 * z;
    }

    @Override
    public void multiply(IMatrix3f other) {
        OpenMatrix3f.multiply(FastLocal.from(other), this, this);
    }

    public void multiplyFront(IMatrix3f other) {
        OpenMatrix3f.multiply(this, FastLocal.from(other), this);
    }

    public void multiplyFront(IQuaternionf other) {
        OpenMatrix3f.multiply(this, FastLocal.fromRot(other), this);
    }

    public void multiply(float ratio) {
        this.m00 *= ratio;
        this.m01 *= ratio;
        this.m02 *= ratio;
        this.m10 *= ratio;
        this.m11 *= ratio;
        this.m12 *= ratio;
        this.m20 *= ratio;
        this.m21 *= ratio;
        this.m22 *= ratio;
    }

    @Override
    public void load(FloatBuffer buffer) {
        this.m00 = buffer.get(OpenMatrix3f.bufferIndex(0, 0));
        this.m01 = buffer.get(OpenMatrix3f.bufferIndex(0, 1));
        this.m02 = buffer.get(OpenMatrix3f.bufferIndex(0, 2));
        this.m10 = buffer.get(OpenMatrix3f.bufferIndex(1, 0));
        this.m11 = buffer.get(OpenMatrix3f.bufferIndex(1, 1));
        this.m12 = buffer.get(OpenMatrix3f.bufferIndex(1, 2));
        this.m20 = buffer.get(OpenMatrix3f.bufferIndex(2, 0));
        this.m21 = buffer.get(OpenMatrix3f.bufferIndex(2, 1));
        this.m22 = buffer.get(OpenMatrix3f.bufferIndex(2, 2));
    }

    @Override
    public void store(FloatBuffer buffer) {
        buffer.put(OpenMatrix3f.bufferIndex(0, 0), this.m00);
        buffer.put(OpenMatrix3f.bufferIndex(0, 1), this.m01);
        buffer.put(OpenMatrix3f.bufferIndex(0, 2), this.m02);
        buffer.put(OpenMatrix3f.bufferIndex(1, 0), this.m10);
        buffer.put(OpenMatrix3f.bufferIndex(1, 1), this.m11);
        buffer.put(OpenMatrix3f.bufferIndex(1, 2), this.m12);
        buffer.put(OpenMatrix3f.bufferIndex(2, 0), this.m20);
        buffer.put(OpenMatrix3f.bufferIndex(2, 1), this.m21);
        buffer.put(OpenMatrix3f.bufferIndex(2, 2), this.m22);
    }

    public void import44(FloatBuffer buffer) {
        this.m00 = buffer.get(OpenMatrix3f.bufferIndex4(0, 0));
        this.m01 = buffer.get(OpenMatrix3f.bufferIndex4(0, 1));
        this.m02 = buffer.get(OpenMatrix3f.bufferIndex4(0, 2));
        this.m10 = buffer.get(OpenMatrix3f.bufferIndex4(1, 0));
        this.m11 = buffer.get(OpenMatrix3f.bufferIndex4(1, 1));
        this.m12 = buffer.get(OpenMatrix3f.bufferIndex4(1, 2));
        this.m20 = buffer.get(OpenMatrix3f.bufferIndex4(2, 0));
        this.m21 = buffer.get(OpenMatrix3f.bufferIndex4(2, 1));
        this.m22 = buffer.get(OpenMatrix3f.bufferIndex4(2, 2));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OpenMatrix3f:\n");
        builder.append(this.m00);
        builder.append(" ");
        builder.append(this.m01);
        builder.append(" ");
        builder.append(this.m02);
        builder.append("\n");
        builder.append(this.m10);
        builder.append(" ");
        builder.append(this.m11);
        builder.append(" ");
        builder.append(this.m12);
        builder.append("\n");
        builder.append(this.m20);
        builder.append(" ");
        builder.append(this.m21);
        builder.append(" ");
        builder.append(this.m22);
        builder.append("\n");
        return builder.toString();
    }

    public OpenMatrix3f set(OpenMatrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        return this;
    }

    public OpenMatrix3f set(OpenMatrix4f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        return this;
    }

    public OpenMatrix3f setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public OpenMatrix3f copy() {
        return new OpenMatrix3f(this);
    }

    public float adjugateAndDet() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float g = -(this.m10 * this.m22 - this.m12 * this.m20);
        float h = this.m10 * this.m21 - this.m11 * this.m20;
        float i = -(this.m01 * this.m22 - this.m02 * this.m21);
        float j = this.m00 * this.m22 - this.m02 * this.m20;
        float k = -(this.m00 * this.m21 - this.m01 * this.m20);
        float l = this.m01 * this.m12 - this.m02 * this.m11;
        float m = -(this.m00 * this.m12 - this.m02 * this.m10);
        float n = this.m00 * this.m11 - this.m01 * this.m10;
        float o = this.m00 * f + this.m01 * g + this.m02 * h;
        this.m00 = f;
        this.m10 = g;
        this.m20 = h;
        this.m01 = i;
        this.m11 = j;
        this.m21 = k;
        this.m02 = l;
        this.m12 = m;
        this.m22 = n;
        return o;
    }

    public float determinant() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float g = -(this.m10 * this.m22 - this.m12 * this.m20);
        float h = this.m10 * this.m21 - this.m11 * this.m20;
        return this.m00 * f + this.m01 * g + this.m02 * h;
    }

    @Override
    public void invert() {
        float f = this.adjugateAndDet();
        if (Math.abs(f) > 1.0E-6f) {
            this.multiply(f);
        }
    }

    @Override
    public void transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenMatrix3f)) {
            return false;
        }
        OpenMatrix3f that = (OpenMatrix3f)o;
        if (Float.compare(that.m00, this.m00) != 0) {
            return false;
        }
        if (Float.compare(that.m11, this.m11) != 0) {
            return false;
        }
        if (Float.compare(that.m22, this.m22) != 0) {
            return false;
        }
        if (Float.compare(that.m20, this.m20) != 0) {
            return false;
        }
        if (Float.compare(that.m21, this.m21) != 0) {
            return false;
        }
        if (Float.compare(that.m01, this.m01) != 0) {
            return false;
        }
        if (Float.compare(that.m02, this.m02) != 0) {
            return false;
        }
        if (Float.compare(that.m10, this.m10) != 0) {
            return false;
        }
        return Float.compare(that.m12, this.m12) == 0;
    }

    public int hashCode() {
        int result = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        result = 31 * result + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        result = 31 * result + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        result = 31 * result + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        result = 31 * result + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        result = 31 * result + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        result = 31 * result + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        result = 31 * result + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        result = 31 * result + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        return result;
    }

    private static int bufferIndex(int i, int j) {
        return j * 3 + i;
    }

    private static int bufferIndex4(int i, int j) {
        return j * 4 + i;
    }

    private static void multiply(OpenMatrix3f lhs, OpenMatrix3f rhs, OpenMatrix3f ret) {
        float m00 = lhs.m00 * rhs.m00 + lhs.m10 * rhs.m01 + lhs.m20 * rhs.m02;
        float m01 = lhs.m01 * rhs.m00 + lhs.m11 * rhs.m01 + lhs.m21 * rhs.m02;
        float m02 = lhs.m02 * rhs.m00 + lhs.m12 * rhs.m01 + lhs.m22 * rhs.m02;
        float m10 = lhs.m00 * rhs.m10 + lhs.m10 * rhs.m11 + lhs.m20 * rhs.m12;
        float m11 = lhs.m01 * rhs.m10 + lhs.m11 * rhs.m11 + lhs.m21 * rhs.m12;
        float m12 = lhs.m02 * rhs.m10 + lhs.m12 * rhs.m11 + lhs.m22 * rhs.m12;
        float m20 = lhs.m00 * rhs.m20 + lhs.m10 * rhs.m21 + lhs.m20 * rhs.m22;
        float m21 = lhs.m01 * rhs.m20 + lhs.m11 * rhs.m21 + lhs.m21 * rhs.m22;
        float m22 = lhs.m02 * rhs.m20 + lhs.m12 * rhs.m21 + lhs.m22 * rhs.m22;
        ret.m00 = m00;
        ret.m01 = m01;
        ret.m02 = m02;
        ret.m10 = m10;
        ret.m11 = m11;
        ret.m12 = m12;
        ret.m20 = m20;
        ret.m21 = m21;
        ret.m22 = m22;
    }

    private static class FastLocal
    extends OpenMatrix3f {
        private static final ThreadLocal<FastLocal> LOCALS = ThreadLocal.withInitial(FastLocal::new);
        private final FloatBuffer buffer = ObjectUtils.createFloatBuffer(9);

        private FastLocal() {
        }

        private static OpenMatrix3f from(IMatrix3f value) {
            if (value instanceof OpenMatrix3f) {
                OpenMatrix3f matrix = (OpenMatrix3f)value;
                return matrix;
            }
            FastLocal local = LOCALS.get();
            value.store(local.buffer);
            local.load(local.buffer);
            return local;
        }

        private static OpenMatrix3f fromRot(IQuaternionf value) {
            FastLocal local = LOCALS.get();
            local.setIdentity();
            local.set(value);
            return local;
        }
    }
}

