/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;

public class OpenMatrix4f
implements IMatrix4f {
    private static final OpenMatrix4f IDENTITY = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public OpenMatrix4f() {
    }

    public OpenMatrix4f(IMatrix4f matrix) {
        FloatBuffer buffer = ObjectUtils.createFloatBuffer(16);
        matrix.store(buffer);
        this.load(buffer);
    }

    public OpenMatrix4f(IQuaternionf quaternion) {
        this.set(quaternion);
    }

    public OpenMatrix4f(FloatBuffer buffer) {
        this.load(buffer);
    }

    public static OpenMatrix4f createScaleMatrix(float x, float y, float z) {
        OpenMatrix4f matrix = new OpenMatrix4f();
        matrix.m00 = x;
        matrix.m11 = y;
        matrix.m22 = z;
        matrix.m33 = 1.0f;
        return matrix;
    }

    public static OpenMatrix4f createTranslateMatrix(float x, float y, float z) {
        OpenMatrix4f matrix = new OpenMatrix4f();
        matrix.m00 = 1.0f;
        matrix.m11 = 1.0f;
        matrix.m22 = 1.0f;
        matrix.m33 = 1.0f;
        matrix.m03 = x;
        matrix.m13 = y;
        matrix.m23 = z;
        return matrix;
    }

    public static OpenMatrix4f identity() {
        return IDENTITY;
    }

    public static OpenMatrix4f of(IMatrix4f o) {
        if (o instanceof OpenMatrix4f) {
            OpenMatrix4f that = (OpenMatrix4f)o;
            return that;
        }
        return new OpenMatrix4f(o);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.multiply(OpenMatrix4f.createScaleMatrix(x, y, z));
    }

    @Override
    public void translate(float x, float y, float z) {
        this.multiply(OpenMatrix4f.createTranslateMatrix(x, y, z));
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        this.multiply(FastLocal.from(quaternion));
    }

    @Override
    public void set(IMatrix4f matrix) {
        this.set(FastLocal.from(matrix));
    }

    public void set(IQuaternionf quaternion) {
        float f = quaternion.x();
        float g = quaternion.y();
        float h = quaternion.z();
        float i = quaternion.w();
        float j = 2.0f * f * f;
        float k = 2.0f * g * g;
        float l = 2.0f * h * h;
        this.m00 = 1.0f - k - l;
        this.m11 = 1.0f - l - j;
        this.m22 = 1.0f - j - k;
        this.m33 = 1.0f;
        float m = f * g;
        float n = g * h;
        float o = h * f;
        float p = f * i;
        float q = g * i;
        float r = h * i;
        this.m10 = 2.0f * (m + r);
        this.m01 = 2.0f * (m - r);
        this.m20 = 2.0f * (o - q);
        this.m02 = 2.0f * (o + q);
        this.m21 = 2.0f * (n + p);
        this.m12 = 2.0f * (n - p);
    }

    @Override
    public void multiply(float[] values) {
        float x = values[0];
        float y = values[1];
        float z = values[2];
        float w = values[3];
        values[0] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03 * w;
        values[1] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13 * w;
        values[2] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23 * w;
        values[3] = this.m30 * x + this.m31 * y + this.m32 * z + this.m33 * w;
    }

    @Override
    public void multiply(IMatrix4f other) {
        OpenMatrix4f.multiply(FastLocal.from(other), this, this);
    }

    public void multiplyFront(IMatrix4f other) {
        OpenMatrix4f.multiply(this, FastLocal.from(other), this);
    }

    public void multiplyFront(IQuaternionf quaternion) {
        this.multiplyFront(FastLocal.from(quaternion));
    }

    public void multiply(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    @Override
    public void load(FloatBuffer buffer) {
        this.m00 = buffer.get(OpenMatrix4f.bufferIndex(0, 0));
        this.m01 = buffer.get(OpenMatrix4f.bufferIndex(0, 1));
        this.m02 = buffer.get(OpenMatrix4f.bufferIndex(0, 2));
        this.m03 = buffer.get(OpenMatrix4f.bufferIndex(0, 3));
        this.m10 = buffer.get(OpenMatrix4f.bufferIndex(1, 0));
        this.m11 = buffer.get(OpenMatrix4f.bufferIndex(1, 1));
        this.m12 = buffer.get(OpenMatrix4f.bufferIndex(1, 2));
        this.m13 = buffer.get(OpenMatrix4f.bufferIndex(1, 3));
        this.m20 = buffer.get(OpenMatrix4f.bufferIndex(2, 0));
        this.m21 = buffer.get(OpenMatrix4f.bufferIndex(2, 1));
        this.m22 = buffer.get(OpenMatrix4f.bufferIndex(2, 2));
        this.m23 = buffer.get(OpenMatrix4f.bufferIndex(2, 3));
        this.m30 = buffer.get(OpenMatrix4f.bufferIndex(3, 0));
        this.m31 = buffer.get(OpenMatrix4f.bufferIndex(3, 1));
        this.m32 = buffer.get(OpenMatrix4f.bufferIndex(3, 2));
        this.m33 = buffer.get(OpenMatrix4f.bufferIndex(3, 3));
    }

    @Override
    public void store(FloatBuffer buffer) {
        buffer.put(OpenMatrix4f.bufferIndex(0, 0), this.m00);
        buffer.put(OpenMatrix4f.bufferIndex(0, 1), this.m01);
        buffer.put(OpenMatrix4f.bufferIndex(0, 2), this.m02);
        buffer.put(OpenMatrix4f.bufferIndex(0, 3), this.m03);
        buffer.put(OpenMatrix4f.bufferIndex(1, 0), this.m10);
        buffer.put(OpenMatrix4f.bufferIndex(1, 1), this.m11);
        buffer.put(OpenMatrix4f.bufferIndex(1, 2), this.m12);
        buffer.put(OpenMatrix4f.bufferIndex(1, 3), this.m13);
        buffer.put(OpenMatrix4f.bufferIndex(2, 0), this.m20);
        buffer.put(OpenMatrix4f.bufferIndex(2, 1), this.m21);
        buffer.put(OpenMatrix4f.bufferIndex(2, 2), this.m22);
        buffer.put(OpenMatrix4f.bufferIndex(2, 3), this.m23);
        buffer.put(OpenMatrix4f.bufferIndex(3, 0), this.m30);
        buffer.put(OpenMatrix4f.bufferIndex(3, 1), this.m31);
        buffer.put(OpenMatrix4f.bufferIndex(3, 2), this.m32);
        buffer.put(OpenMatrix4f.bufferIndex(3, 3), this.m33);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OpenMatrix4f:\n");
        builder.append(this.m00);
        builder.append(" ");
        builder.append(this.m01);
        builder.append(" ");
        builder.append(this.m02);
        builder.append(" ");
        builder.append(this.m03);
        builder.append("\n");
        builder.append(this.m10);
        builder.append(" ");
        builder.append(this.m11);
        builder.append(" ");
        builder.append(this.m12);
        builder.append(" ");
        builder.append(this.m13);
        builder.append("\n");
        builder.append(this.m20);
        builder.append(" ");
        builder.append(this.m21);
        builder.append(" ");
        builder.append(this.m22);
        builder.append(" ");
        builder.append(this.m23);
        builder.append("\n");
        builder.append(this.m30);
        builder.append(" ");
        builder.append(this.m31);
        builder.append(" ");
        builder.append(this.m32);
        builder.append(" ");
        builder.append(this.m33);
        builder.append("\n");
        return builder.toString();
    }

    public OpenMatrix4f set(OpenMatrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = 0.0f;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = 0.0f;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public OpenMatrix4f set(OpenMatrix4f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m03 = mat.m03;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m30 = mat.m30;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
        return this;
    }

    public OpenMatrix4f setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public OpenMatrix4f copy() {
        return new OpenMatrix4f(this);
    }

    public float adjugateAndDet() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float g = this.m00 * this.m12 - this.m02 * this.m10;
        float h = this.m00 * this.m13 - this.m03 * this.m10;
        float i = this.m01 * this.m12 - this.m02 * this.m11;
        float j = this.m01 * this.m13 - this.m03 * this.m11;
        float k = this.m02 * this.m13 - this.m03 * this.m12;
        float l = this.m20 * this.m31 - this.m21 * this.m30;
        float m = this.m20 * this.m32 - this.m22 * this.m30;
        float n = this.m20 * this.m33 - this.m23 * this.m30;
        float o = this.m21 * this.m32 - this.m22 * this.m31;
        float p = this.m21 * this.m33 - this.m23 * this.m31;
        float q = this.m22 * this.m33 - this.m23 * this.m32;
        float r = this.m11 * q - this.m12 * p + this.m13 * o;
        float s = -this.m10 * q + this.m12 * n - this.m13 * m;
        float t = this.m10 * p - this.m11 * n + this.m13 * l;
        float u = -this.m10 * o + this.m11 * m - this.m12 * l;
        float v = -this.m01 * q + this.m02 * p - this.m03 * o;
        float w = this.m00 * q - this.m02 * n + this.m03 * m;
        float x = -this.m00 * p + this.m01 * n - this.m03 * l;
        float y = this.m00 * o - this.m01 * m + this.m02 * l;
        float z = this.m31 * k - this.m32 * j + this.m33 * i;
        float aa = -this.m30 * k + this.m32 * h - this.m33 * g;
        float ab = this.m30 * j - this.m31 * h + this.m33 * f;
        float ac = -this.m30 * i + this.m31 * g - this.m32 * f;
        float ad = -this.m21 * k + this.m22 * j - this.m23 * i;
        float ae = this.m20 * k - this.m22 * h + this.m23 * g;
        float af = -this.m20 * j + this.m21 * h - this.m23 * f;
        float ag = this.m20 * i - this.m21 * g + this.m22 * f;
        this.m00 = r;
        this.m10 = s;
        this.m20 = t;
        this.m30 = u;
        this.m01 = v;
        this.m11 = w;
        this.m21 = x;
        this.m31 = y;
        this.m02 = z;
        this.m12 = aa;
        this.m22 = ab;
        this.m32 = ac;
        this.m03 = ad;
        this.m13 = ae;
        this.m23 = af;
        this.m33 = ag;
        return f * q - g * p + h * o + i * n - j * m + k * l;
    }

    public float determinant() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float g = this.m00 * this.m12 - this.m02 * this.m10;
        float h = this.m00 * this.m13 - this.m03 * this.m10;
        float i = this.m01 * this.m12 - this.m02 * this.m11;
        float j = this.m01 * this.m13 - this.m03 * this.m11;
        float k = this.m02 * this.m13 - this.m03 * this.m12;
        float l = this.m20 * this.m31 - this.m21 * this.m30;
        float m = this.m20 * this.m32 - this.m22 * this.m30;
        float n = this.m20 * this.m33 - this.m23 * this.m30;
        float o = this.m21 * this.m32 - this.m22 * this.m31;
        float p = this.m21 * this.m33 - this.m23 * this.m31;
        float q = this.m22 * this.m33 - this.m23 * this.m32;
        return f * q - g * p + h * o + i * n - j * m + k * l;
    }

    @Override
    public void transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        f = this.m30;
        this.m30 = this.m03;
        this.m03 = f;
        f = this.m31;
        this.m31 = this.m13;
        this.m13 = f;
        f = this.m32;
        this.m32 = this.m23;
        this.m23 = f;
    }

    @Override
    public void invert() {
        OpenMatrix4f.invertGeneric(this, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenMatrix4f)) {
            return false;
        }
        OpenMatrix4f that = (OpenMatrix4f)o;
        if (Float.compare(that.m10, this.m10) != 0) {
            return false;
        }
        if (Float.compare(that.m20, this.m20) != 0) {
            return false;
        }
        if (Float.compare(that.m30, this.m30) != 0) {
            return false;
        }
        if (Float.compare(that.m00, this.m00) != 0) {
            return false;
        }
        if (Float.compare(that.m11, this.m11) != 0) {
            return false;
        }
        if (Float.compare(that.m22, this.m22) != 0) {
            return false;
        }
        if (Float.compare(that.m33, this.m33) != 0) {
            return false;
        }
        if (Float.compare(that.m31, this.m31) != 0) {
            return false;
        }
        if (Float.compare(that.m32, this.m32) != 0) {
            return false;
        }
        if (Float.compare(that.m01, this.m01) != 0) {
            return false;
        }
        if (Float.compare(that.m02, this.m02) != 0) {
            return false;
        }
        if (Float.compare(that.m03, this.m03) != 0) {
            return false;
        }
        if (Float.compare(that.m12, this.m12) != 0) {
            return false;
        }
        if (Float.compare(that.m13, this.m13) != 0) {
            return false;
        }
        if (Float.compare(that.m21, this.m21) != 0) {
            return false;
        }
        return Float.compare(that.m23, this.m23) == 0;
    }

    public int hashCode() {
        int result = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        result = 31 * result + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        result = 31 * result + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        result = 31 * result + (this.m03 != 0.0f ? Float.floatToIntBits(this.m03) : 0);
        result = 31 * result + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        result = 31 * result + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        result = 31 * result + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        result = 31 * result + (this.m13 != 0.0f ? Float.floatToIntBits(this.m13) : 0);
        result = 31 * result + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        result = 31 * result + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        result = 31 * result + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        result = 31 * result + (this.m23 != 0.0f ? Float.floatToIntBits(this.m23) : 0);
        result = 31 * result + (this.m30 != 0.0f ? Float.floatToIntBits(this.m30) : 0);
        result = 31 * result + (this.m31 != 0.0f ? Float.floatToIntBits(this.m31) : 0);
        result = 31 * result + (this.m32 != 0.0f ? Float.floatToIntBits(this.m32) : 0);
        result = 31 * result + (this.m33 != 0.0f ? Float.floatToIntBits(this.m33) : 0);
        return result;
    }

    private static int bufferIndex(int i, int j) {
        return j * 4 + i;
    }

    private static void invertGeneric(OpenMatrix4f in, OpenMatrix4f ret) {
        float a = in.m00 * in.m11 - in.m01 * in.m10;
        float b = in.m00 * in.m12 - in.m02 * in.m10;
        float c = in.m00 * in.m13 - in.m03 * in.m10;
        float d = in.m01 * in.m12 - in.m02 * in.m11;
        float e = in.m01 * in.m13 - in.m03 * in.m11;
        float f = in.m02 * in.m13 - in.m03 * in.m12;
        float g = in.m20 * in.m31 - in.m21 * in.m30;
        float h = in.m20 * in.m32 - in.m22 * in.m30;
        float i = in.m20 * in.m33 - in.m23 * in.m30;
        float j = in.m21 * in.m32 - in.m22 * in.m31;
        float k = in.m21 * in.m33 - in.m23 * in.m31;
        float l = in.m22 * in.m33 - in.m23 * in.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float m00 = MathUtils.fma(in.m11, l, MathUtils.fma(-in.m12, k, in.m13 * j)) * det;
        float m01 = MathUtils.fma(-in.m01, l, MathUtils.fma(in.m02, k, -in.m03 * j)) * det;
        float m02 = MathUtils.fma(in.m31, f, MathUtils.fma(-in.m32, e, in.m33 * d)) * det;
        float m03 = MathUtils.fma(-in.m21, f, MathUtils.fma(in.m22, e, -in.m23 * d)) * det;
        float m10 = MathUtils.fma(-in.m10, l, MathUtils.fma(in.m12, i, -in.m13 * h)) * det;
        float m11 = MathUtils.fma(in.m00, l, MathUtils.fma(-in.m02, i, in.m03 * h)) * det;
        float m12 = MathUtils.fma(-in.m30, f, MathUtils.fma(in.m32, c, -in.m33 * b)) * det;
        float m13 = MathUtils.fma(in.m20, f, MathUtils.fma(-in.m22, c, in.m23 * b)) * det;
        float m20 = MathUtils.fma(in.m10, k, MathUtils.fma(-in.m11, i, in.m13 * g)) * det;
        float m21 = MathUtils.fma(-in.m00, k, MathUtils.fma(in.m01, i, -in.m03 * g)) * det;
        float m22 = MathUtils.fma(in.m30, e, MathUtils.fma(-in.m31, c, in.m33 * a)) * det;
        float m23 = MathUtils.fma(-in.m20, e, MathUtils.fma(in.m21, c, -in.m23 * a)) * det;
        float m30 = MathUtils.fma(-in.m10, j, MathUtils.fma(in.m11, h, -in.m12 * g)) * det;
        float m31 = MathUtils.fma(in.m00, j, MathUtils.fma(-in.m01, h, in.m02 * g)) * det;
        float m32 = MathUtils.fma(-in.m30, d, MathUtils.fma(in.m31, b, -in.m32 * a)) * det;
        float m33 = MathUtils.fma(in.m20, d, MathUtils.fma(-in.m21, b, in.m22 * a)) * det;
        ret.m00 = m00;
        ret.m01 = m01;
        ret.m02 = m02;
        ret.m03 = m03;
        ret.m10 = m10;
        ret.m11 = m11;
        ret.m12 = m12;
        ret.m13 = m13;
        ret.m20 = m20;
        ret.m21 = m21;
        ret.m22 = m22;
        ret.m23 = m23;
        ret.m30 = m30;
        ret.m31 = m31;
        ret.m32 = m32;
        ret.m33 = m33;
    }

    private static void multiply(OpenMatrix4f lhs, OpenMatrix4f rhs, OpenMatrix4f ret) {
        float m00 = lhs.m00 * rhs.m00 + lhs.m10 * rhs.m01 + lhs.m20 * rhs.m02 + lhs.m30 * rhs.m03;
        float m01 = lhs.m01 * rhs.m00 + lhs.m11 * rhs.m01 + lhs.m21 * rhs.m02 + lhs.m31 * rhs.m03;
        float m02 = lhs.m02 * rhs.m00 + lhs.m12 * rhs.m01 + lhs.m22 * rhs.m02 + lhs.m32 * rhs.m03;
        float m03 = lhs.m03 * rhs.m00 + lhs.m13 * rhs.m01 + lhs.m23 * rhs.m02 + lhs.m33 * rhs.m03;
        float m10 = lhs.m00 * rhs.m10 + lhs.m10 * rhs.m11 + lhs.m20 * rhs.m12 + lhs.m30 * rhs.m13;
        float m11 = lhs.m01 * rhs.m10 + lhs.m11 * rhs.m11 + lhs.m21 * rhs.m12 + lhs.m31 * rhs.m13;
        float m12 = lhs.m02 * rhs.m10 + lhs.m12 * rhs.m11 + lhs.m22 * rhs.m12 + lhs.m32 * rhs.m13;
        float m13 = lhs.m03 * rhs.m10 + lhs.m13 * rhs.m11 + lhs.m23 * rhs.m12 + lhs.m33 * rhs.m13;
        float m20 = lhs.m00 * rhs.m20 + lhs.m10 * rhs.m21 + lhs.m20 * rhs.m22 + lhs.m30 * rhs.m23;
        float m21 = lhs.m01 * rhs.m20 + lhs.m11 * rhs.m21 + lhs.m21 * rhs.m22 + lhs.m31 * rhs.m23;
        float m22 = lhs.m02 * rhs.m20 + lhs.m12 * rhs.m21 + lhs.m22 * rhs.m22 + lhs.m32 * rhs.m23;
        float m23 = lhs.m03 * rhs.m20 + lhs.m13 * rhs.m21 + lhs.m23 * rhs.m22 + lhs.m33 * rhs.m23;
        float m30 = lhs.m00 * rhs.m30 + lhs.m10 * rhs.m31 + lhs.m20 * rhs.m32 + lhs.m30 * rhs.m33;
        float m31 = lhs.m01 * rhs.m30 + lhs.m11 * rhs.m31 + lhs.m21 * rhs.m32 + lhs.m31 * rhs.m33;
        float m32 = lhs.m02 * rhs.m30 + lhs.m12 * rhs.m31 + lhs.m22 * rhs.m32 + lhs.m32 * rhs.m33;
        float m33 = lhs.m03 * rhs.m30 + lhs.m13 * rhs.m31 + lhs.m23 * rhs.m32 + lhs.m33 * rhs.m33;
        ret.m00 = m00;
        ret.m01 = m01;
        ret.m02 = m02;
        ret.m03 = m03;
        ret.m10 = m10;
        ret.m11 = m11;
        ret.m12 = m12;
        ret.m13 = m13;
        ret.m20 = m20;
        ret.m21 = m21;
        ret.m22 = m22;
        ret.m23 = m23;
        ret.m30 = m30;
        ret.m31 = m31;
        ret.m32 = m32;
        ret.m33 = m33;
    }

    private static class FastLocal
    extends OpenMatrix4f {
        private static final ThreadLocal<FastLocal> LOCALS = ThreadLocal.withInitial(FastLocal::new);
        private final FloatBuffer buffer = ObjectUtils.createFloatBuffer(16);

        private FastLocal() {
        }

        private static OpenMatrix4f from(IMatrix4f value) {
            if (value instanceof OpenMatrix4f) {
                OpenMatrix4f matrix = (OpenMatrix4f)value;
                return matrix;
            }
            FastLocal local = LOCALS.get();
            value.store(local.buffer);
            local.load(local.buffer);
            return local;
        }

        private static OpenMatrix4f from(IQuaternionf value) {
            FastLocal local = LOCALS.get();
            local.setIdentity();
            local.set(value);
            return local;
        }
    }
}

