/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenNearPlane {
    private final float fov;
    private final float width;
    private final float height;
    private final Vector3f forwards = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);

    public OpenNearPlane(float rx, float ry, float width, float height, float fov) {
        OpenQuaternionf quaternion = OpenQuaternionf.fromYXZ(-ry * ((float)Math.PI / 180), rx * ((float)Math.PI / 180), 0.0f);
        this.forwards.transform(quaternion);
        this.up.transform(quaternion);
        this.left.transform(quaternion);
        this.fov = fov;
        this.width = width;
        this.height = height;
    }

    public Vector3f at(float deltaX, float deltaY, float deltaZ) {
        float d0 = this.width / this.height;
        float d1 = (float)Math.tan((double)this.fov / 2.0 * (Math.PI / 180));
        float sx = deltaX * deltaZ * d1 * d0;
        float sy = deltaY * deltaZ * d1;
        float sz = deltaZ;
        float tx = this.forwards.getX() * sz + this.up.getX() * sy - this.left.getX() * sx;
        float ty = this.forwards.getY() * sz + this.up.getY() * sy - this.left.getY() * sx;
        float tz = this.forwards.getZ() * sz + this.up.getZ() * sy - this.left.getZ() * sx;
        return new Vector3f(tx, ty, tz);
    }

    public Vector3f getLookVector() {
        return this.forwards;
    }

    public Vector3f getUpVector() {
        return this.up;
    }

    public Vector3f getLeftVector() {
        return this.left;
    }
}

