/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenQuaternionf
implements IQuaternionf {
    public static final OpenQuaternionf ONE = new OpenQuaternionf();
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    public float x;
    public float y;
    public float z;
    public float w;

    public OpenQuaternionf() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public OpenQuaternionf(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public OpenQuaternionf(Vector3f vec, float f, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
        }
        float g = MathUtils.sin(f / 2.0f);
        this.x = vec.getX() * g;
        this.y = vec.getY() * g;
        this.z = vec.getZ() * g;
        this.w = MathUtils.cos(f / 2.0f);
    }

    public OpenQuaternionf(float x, float y, float z, boolean bl) {
        if (bl) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        float i = OpenQuaternionf.sin(0.5f * x);
        float j = OpenQuaternionf.cos(0.5f * x);
        float k = OpenQuaternionf.sin(0.5f * y);
        float l = OpenQuaternionf.cos(0.5f * y);
        float m = OpenQuaternionf.sin(0.5f * z);
        float n = OpenQuaternionf.cos(0.5f * z);
        this.x = i * l * n + j * k * m;
        this.y = j * k * n - i * l * m;
        this.z = i * k * n + j * l * m;
        this.w = j * l * n - i * k * m;
    }

    public OpenQuaternionf(IQuaternionf other) {
        this.x = other.x();
        this.y = other.y();
        this.z = other.z();
        this.w = other.w();
    }

    public static OpenQuaternionf fromXYZ(float angleX, float angleY, float angleZ) {
        float sx = MathUtils.sin(angleX * 0.5f);
        float cx = MathUtils.cosFromSin(sx, angleX * 0.5f);
        float sy = MathUtils.sin(angleY * 0.5f);
        float cy = MathUtils.cosFromSin(sy, angleY * 0.5f);
        float sz = MathUtils.sin(angleZ * 0.5f);
        float cz = MathUtils.cosFromSin(sz, angleZ * 0.5f);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        return new OpenQuaternionf(sx * cycz + cx * sysz, cx * sycz - sx * cysz, cx * cysz + sx * sycz, cx * cycz - sx * sysz);
    }

    public static OpenQuaternionf fromZYX(float angleZ, float angleY, float angleX) {
        float sx = MathUtils.sin(angleX * 0.5f);
        float cx = MathUtils.cosFromSin(sx, angleX * 0.5f);
        float sy = MathUtils.sin(angleY * 0.5f);
        float cy = MathUtils.cosFromSin(sy, angleY * 0.5f);
        float sz = MathUtils.sin(angleZ * 0.5f);
        float cz = MathUtils.cosFromSin(sz, angleZ * 0.5f);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        return new OpenQuaternionf(sx * cycz - cx * sysz, cx * sycz + sx * cysz, cx * cysz - sx * sycz, cx * cycz + sx * sysz);
    }

    public static OpenQuaternionf fromYXZ(float angleY, float angleX, float angleZ) {
        float sx = MathUtils.sin(angleX * 0.5f);
        float cx = MathUtils.cosFromSin(sx, angleX * 0.5f);
        float sy = MathUtils.sin(angleY * 0.5f);
        float cy = MathUtils.cosFromSin(sy, angleY * 0.5f);
        float sz = MathUtils.sin(angleZ * 0.5f);
        float cz = MathUtils.cosFromSin(sz, angleZ * 0.5f);
        float x = cy * sx;
        float y = sy * cx;
        float z = sy * sx;
        float w = cy * cx;
        return new OpenQuaternionf(x * cz + y * sz, y * cz - x * sz, w * sz - z * cz, w * cz + z * sz);
    }

    public static OpenQuaternionf fromXYZ(IVector3f value, boolean bl) {
        float x = value.getX();
        float y = value.getY();
        float z = value.getZ();
        if (bl) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return OpenQuaternionf.fromXYZ(x, y, z);
    }

    public static OpenQuaternionf fromZYX(IVector3f value, boolean bl) {
        float x = value.getX();
        float y = value.getY();
        float z = value.getZ();
        if (bl) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return OpenQuaternionf.fromZYX(z, y, x);
    }

    public static OpenQuaternionf fromYXZ(IVector3f value, boolean bl) {
        float x = value.getX();
        float y = value.getY();
        float z = value.getZ();
        if (bl) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return OpenQuaternionf.fromYXZ(y, x, z);
    }

    public Vector3f toXYZ() {
        float f = this.w * this.w;
        float g = this.x * this.x;
        float h = this.y * this.y;
        float i = this.z * this.z;
        float j = f + g + h + i;
        float k = 2.0f * this.w * this.x - 2.0f * this.y * this.z;
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new Vector3f(2.0f * (float)Math.atan2(this.x, this.w), l, 0.0f);
        }
        return new Vector3f((float)Math.atan2(2.0f * this.y * this.z + 2.0f * this.x * this.w, f - g - h + i), l, (float)Math.atan2(2.0f * this.x * this.y + 2.0f * this.w * this.z, f + g - h - i));
    }

    public Vector3f toYXZ() {
        float f = this.w * this.w;
        float g = this.x * this.x;
        float h = this.y * this.y;
        float i = this.z * this.z;
        float j = f + g + h + i;
        float k = 2.0f * this.w * this.x - 2.0f * this.y * this.z;
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new Vector3f(l, 2.0f * (float)Math.atan2(this.y, this.w), 0.0f);
        }
        return new Vector3f(l, (float)Math.atan2(2.0f * this.x * this.z + 2.0f * this.y * this.w, f - g - h + i), (float)Math.atan2(2.0f * this.x * this.y + 2.0f * this.w * this.z, f - g + h - i));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OpenQuaternionf quaternion = (OpenQuaternionf)object;
        if (Float.compare(quaternion.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(quaternion.y, this.y) != 0) {
            return false;
        }
        if (Float.compare(quaternion.z, this.z) != 0) {
            return false;
        }
        return Float.compare(quaternion.w, this.w) == 0;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        i = 31 * i + Float.floatToIntBits(this.z);
        i = 31 * i + Float.floatToIntBits(this.w);
        return i;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quaternionf[").append(this.w).append(" + ");
        stringBuilder.append(this.x).append("i + ");
        stringBuilder.append(this.y).append("j + ");
        stringBuilder.append(this.z).append("k]");
        return stringBuilder.toString();
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public float w() {
        return this.w;
    }

    public void mul(OpenQuaternionf other) {
        float f = this.x;
        float g = this.y;
        float h = this.z;
        float i = this.w;
        float j = other.x;
        float k = other.y;
        float l = other.z;
        float m = other.w;
        this.x = i * j + f * m + g * l - h * k;
        this.y = i * k - f * l + g * m + h * j;
        this.z = i * l + f * k - g * j + h * m;
        this.w = i * m - f * j - g * k - h * l;
    }

    public void mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
    }

    public float dot(OpenQuaternionf other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public OpenQuaternionf conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public OpenQuaternionf inverse() {
        return this.conjugate();
    }

    public void set(float f, float g, float h, float i) {
        this.x = f;
        this.y = g;
        this.z = h;
        this.w = i;
    }

    public void set(OpenQuaternionf other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
    }

    private static float cos(float f) {
        return (float)Math.cos(f);
    }

    private static float sin(float f) {
        return (float)Math.sin(f);
    }

    public OpenQuaternionf normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f > 1.0E-6f) {
            float g = MathUtils.fastInvSqrt(f);
            this.x *= g;
            this.y *= g;
            this.z *= g;
            this.w *= g;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.w = 0.0f;
        }
        return this;
    }

    public void slerp(OpenQuaternionf quaternion, float f) {
        throw new UnsupportedOperationException();
    }

    public OpenQuaternionf copy() {
        return new OpenQuaternionf(this);
    }
}

