/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.Objects;
import moe.plushie.armourers_workshop.utils.math.Vector2f;

public class Rectangle2f {
    public static final Rectangle2f ZERO = new Rectangle2f(0.0f, 0.0f, 0.0f, 0.0f);
    private float x;
    private float y;
    private float width;
    private float height;

    public Rectangle2f(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getMinX() {
        return this.x;
    }

    public float getMinY() {
        return this.y;
    }

    public float getMidX() {
        return this.x + this.width / 2.0f;
    }

    public float getMidY() {
        return this.y + this.height / 2.0f;
    }

    public float getMaxX() {
        return this.x + this.width;
    }

    public float getMaxY() {
        return this.y + this.height;
    }

    public Rectangle2f copy() {
        return new Rectangle2f(this.x, this.y, this.width, this.height);
    }

    public Rectangle2f scale(float s) {
        return new Rectangle2f(this.x * s, this.y * s, this.width * s, this.height * s);
    }

    public Rectangle2f offset(Vector2f point) {
        return this.offset((float)point.x(), (float)point.y());
    }

    public Rectangle2f offset(float dx, float dy) {
        return new Rectangle2f(this.x + dx, this.y + dy, this.width, this.height);
    }

    public boolean contains(Vector2f point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(float tx, float ty) {
        return this.x <= tx && tx <= this.x + this.width && this.y <= ty && ty <= this.y + this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2f)) {
            return false;
        }
        Rectangle2f that = (Rectangle2f)o;
        return Float.compare(this.x, that.x) == 0 && Float.compare(this.y, that.y) == 0 && Float.compare(this.width, that.width) == 0 && Float.compare(this.height, that.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return String.format("(%g %g; %g %g)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }
}

