/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.EnumSet;
import java.util.Objects;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;

public class Vector3d
implements Position {
    public static final Vector3d ZERO = new Vector3d(0.0, 0.0, 0.0);
    public final double x;
    public final double y;
    public final double z;

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(Position pos) {
        this(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public static Vector3d fromRGB24(int rgb) {
        double d0 = (double)(rgb >> 16 & 0xFF) / 255.0;
        double d1 = (double)(rgb >> 8 & 0xFF) / 255.0;
        double d2 = (double)(rgb & 0xFF) / 255.0;
        return new Vector3d(d0, d1, d2);
    }

    public static Vector3d atCenterOf(BlockPos pos) {
        return new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static Vector3d atLowerCornerOf(BlockPos pos) {
        return new Vector3d(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Vector3d atBottomCenterOf(BlockPos pos) {
        return new Vector3d((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static Vector3d upFromBottomCenterOf(BlockPos pos, double offset) {
        return new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + offset, (double)pos.m_123343_() + 0.5);
    }

    public static Vector3d directionFromRotation(float p_189986_0_, float p_189986_1_) {
        float f = MathUtils.cos(-p_189986_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = MathUtils.sin(-p_189986_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathUtils.cos(-p_189986_0_ * ((float)Math.PI / 180));
        float f3 = MathUtils.sin(-p_189986_0_ * ((float)Math.PI / 180));
        return new Vector3d(f1 * f2, f3, f * f2);
    }

    public Vector3d vectorTo(Vector3d pos) {
        return new Vector3d(pos.x - this.x, pos.y - this.y, pos.z - this.z);
    }

    public Vector3d normalize() {
        double d0 = MathUtils.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return d0 < 1.0E-4 ? ZERO : new Vector3d(this.x / d0, this.y / d0, this.z / d0);
    }

    public double dot(Vector3d vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3d cross(Vector3d vec) {
        return new Vector3d(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public Vector3d subtract(Vector3d delta) {
        return this.subtract(delta.x, delta.y, delta.z);
    }

    public Vector3d subtract(double tx, double ty, double tz) {
        return this.add(-tx, -ty, -tz);
    }

    public Vector3d add(Vector3d delta) {
        return this.add(delta.x, delta.y, delta.z);
    }

    public Vector3d add(double tx, double ty, double tz) {
        return new Vector3d(this.x + tx, this.y + ty, this.z + tz);
    }

    public boolean closerThan(Position pos, double p_237488_2_) {
        return this.distanceToSqr(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()) < p_237488_2_ * p_237488_2_;
    }

    public double distanceTo(Vector3d pos) {
        double d0 = pos.x - this.x;
        double d1 = pos.y - this.y;
        double d2 = pos.z - this.z;
        return MathUtils.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double distanceToSqr(Vector3d pos) {
        double d0 = pos.x - this.x;
        double d1 = pos.y - this.y;
        double d2 = pos.z - this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distanceToSqr(double tx, double ty, double tz) {
        double d0 = tx - this.x;
        double d1 = ty - this.y;
        double d2 = tz - this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vector3d scale(double v) {
        return this.multiply(v, v, v);
    }

    public Vector3d reverse() {
        return this.scale(-1.0);
    }

    public Vector3d multiply(Vector3d pos) {
        return this.multiply(pos.x, pos.y, pos.z);
    }

    public Vector3d multiply(double dx, double dy, double dz) {
        return new Vector3d(this.x * dx, this.y * dy, this.z * dz);
    }

    public double length() {
        return MathUtils.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector3d)) {
            return false;
        }
        Vector3d that = (Vector3d)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.z, that.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("(%g %g %g)", this.x, this.y, this.z);
    }

    public Vector3d xRot(float p_178789_1_) {
        double f = MathUtils.cos(p_178789_1_);
        double f1 = MathUtils.sin(p_178789_1_);
        double d0 = this.x;
        double d1 = this.y * f + this.z * f1;
        double d2 = this.z * f - this.y * f1;
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d yRot(float p_178785_1_) {
        double f = MathUtils.cos(p_178785_1_);
        double f1 = MathUtils.sin(p_178785_1_);
        double d0 = this.x * f + this.z * f1;
        double d1 = this.y;
        double d2 = this.z * f - this.x * f1;
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d zRot(float p_242988_1_) {
        double f = MathUtils.cos(p_242988_1_);
        double f1 = MathUtils.sin(p_242988_1_);
        double d0 = this.x * f + this.y * f1;
        double d1 = this.y * f - this.x * f1;
        double d2 = this.z;
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d align(EnumSet<Direction.Axis> set) {
        double d0 = set.contains(Direction.Axis.X) ? (double)MathUtils.floor(this.x) : this.x;
        double d1 = set.contains(Direction.Axis.Y) ? (double)MathUtils.floor(this.y) : this.y;
        double d2 = set.contains(Direction.Axis.Z) ? (double)MathUtils.floor(this.z) : this.z;
        return new Vector3d(d0, d1, d2);
    }

    public double get(Direction.Axis axis) {
        return axis.m_6150_(this.x, this.y, this.z);
    }

    public double m_7096_() {
        return this.x;
    }

    public double m_7098_() {
        return this.y;
    }

    public double m_7094_() {
        return this.z;
    }
}

