/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;

public class Vector3i
implements Comparable<Vector3i>,
IVector3i,
Position {
    public static final Vector3i ZERO = new Vector3i(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(double x, double y, double z) {
        this(MathUtils.floor(x), MathUtils.floor(y), MathUtils.floor(z));
    }

    public Vector3i(Position pos) {
        this(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public Vector3i(IVector3i pos) {
        this(pos.getX(), pos.getY(), pos.getZ());
    }

    public Vector3i(List<Integer> values) {
        this(values.get(0), values.get(1), values.get(2));
    }

    @Override
    public int compareTo(Vector3i v) {
        int dy = this.getY() - v.getY();
        if (dy != 0) {
            return dy;
        }
        int dz = this.getZ() - v.getZ();
        if (dz != 0) {
            return dz;
        }
        return this.getX() - v.getX();
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public double m_7096_() {
        return this.x;
    }

    public double m_7098_() {
        return this.y;
    }

    public double m_7094_() {
        return this.z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int get(Direction.Axis axis) {
        return axis.m_7863_(this.x, this.y, this.z);
    }

    public Vector3i above() {
        return this.above(1);
    }

    public Vector3i above(int step) {
        return this.relative(Direction.UP, step);
    }

    public Vector3i below() {
        return this.below(1);
    }

    public Vector3i below(int step) {
        return this.relative(Direction.DOWN, step);
    }

    public Vector3i relative(Direction dir, int i) {
        if (i == 0) {
            return this;
        }
        return new Vector3i(this.getX() + dir.m_122429_() * i, this.getY() + dir.m_122430_() * i, this.getZ() + dir.m_122431_() * i);
    }

    public Vector3i cross(Vector3i pos) {
        return new Vector3i(this.getY() * pos.getZ() - this.getZ() * pos.getY(), this.getZ() * pos.getX() - this.getX() * pos.getZ(), this.getX() * pos.getY() - this.getY() * pos.getX());
    }

    public boolean closerThan(Vector3i pos, double d) {
        return this.distSqr(pos.getX(), pos.getY(), pos.getZ(), false) < d * d;
    }

    public boolean closerThan(Position v, double f) {
        return this.distSqr(v.m_7096_(), v.m_7098_(), v.m_7094_(), true) < f * f;
    }

    public double distSqr(Vector3i v) {
        return this.distSqr(v.getX(), v.getY(), v.getZ(), true);
    }

    public double distSqr(Position v, boolean fl) {
        return this.distSqr(v.m_7096_(), v.m_7098_(), v.m_7094_(), fl);
    }

    public double distSqr(double tx, double ty, double tz, boolean p_218140_7_) {
        double d0 = p_218140_7_ ? 0.5 : 0.0;
        double d1 = (double)this.getX() + d0 - tx;
        double d2 = (double)this.getY() + d0 - ty;
        double d3 = (double)this.getZ() + d0 - tz;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public int distManhattan(Vector3i pos) {
        float f = Math.abs(pos.getX() - this.getX());
        float f1 = Math.abs(pos.getY() - this.getY());
        float f2 = Math.abs(pos.getZ() - this.getZ());
        return (int)(f + f1 + f2);
    }

    public List<Integer> toList() {
        return Lists.newArrayList((Object[])new Integer[]{this.x, this.y, this.z});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector3i)) {
            return false;
        }
        Vector3i that = (Vector3i)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("(%d %d %d)", this.x, this.y, this.z);
    }
}

