/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.util.DamageSourceHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public abstract class PendantItem
extends WearableArtifactItem {
    private final Supplier<Double> strikeChance;
    private final Supplier<Integer> cooldown;

    public PendantItem(Supplier<Double> strikeChance, Supplier<Integer> cooldown) {
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public double getStrikeChance() {
        return this.strikeChance.get();
    }

    protected EventResult onLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (this.isEquippedBy(entity) && !entity.m_9236_().m_5776_() && amount >= 1.0f && attacker != null && !this.isOnCooldown(entity) && entity.m_217043_().m_188500_() < this.getStrikeChance()) {
            this.applyEffect(entity, attacker);
            this.addCooldown(entity, this.cooldown.get());
        }
        return EventResult.pass();
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2);

    @Override
    protected boolean hasNonCosmeticEffects() {
        return this.getStrikeChance() > 0.0;
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11673_;
    }
}

