/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.pins.Pinnable;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.io.IOUtils;

public class PinnedRecipeManager {
    public HashSet<ResourceLocation> pinned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        Gson gson = new Gson();
        JsonReader reader = null;
        try {
            File pinsFile = new File(Minecraft.m_91087_().f_91069_, "brb.pins");
            if (pinsFile.exists()) {
                reader = new JsonReader((Reader)new FileReader(pinsFile.getAbsolutePath()));
                Type type = new TypeToken<HashSet<ResourceLocation>>(){}.getType();
                this.pinned = (HashSet)gson.fromJson(reader, type);
            }
        }
        catch (Throwable var8) {
            BetterRecipeBook.LOGGER.error("brb.pins could not be read.");
        }
        finally {
            if (this.pinned == null) {
                this.pinned = new HashSet();
            }
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        Gson gson = new Gson();
        OutputStreamWriter writer = null;
        try {
            File pinsFile = new File(Minecraft.m_91087_().f_91069_, "brb.pins");
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pinsFile), StandardCharsets.UTF_8);
            writer.write(gson.toJson(this.pinned));
        }
        catch (Throwable var8) {
            try {
                BetterRecipeBook.LOGGER.error("brb.pins could not be saved.");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void addOrRemoveFavourite(RecipeCollection target) {
        for (ResourceLocation identifier : this.pinned) {
            for (Recipe recipe : target.m_100516_()) {
                if (!recipe.m_6423_().equals((Object)identifier)) continue;
                this.pinned.remove(identifier);
                this.store();
                return;
            }
        }
        this.pinned.addAll(target.m_100516_().stream().map(Recipe::m_6423_).toList());
        this.store();
    }

    public <R extends GenericRecipe, M extends AbstractContainerMenu> void addOrRemoveFavourite(GenericRecipeBookCollection<R, M> target) {
        for (ResourceLocation identifier : this.pinned) {
            for (GenericRecipe recipe : target.getRecipes()) {
                if (!recipe.id().equals((Object)identifier)) continue;
                this.pinned.remove(identifier);
                this.store();
                return;
            }
        }
        this.pinned.addAll(target.getRecipes().stream().map(GenericRecipe::id).toList());
        this.store();
    }

    public boolean has(Pinnable target) {
        for (ResourceLocation identifier : this.pinned) {
            if (!target.has(identifier)) continue;
            return true;
        }
        return false;
    }

    public static void handlePinRecipe(RecipeBookComponent book, RecipeBookPage page, Recipe<?> recipe) {
        RecipeCollection collection = new RecipeCollection(Minecraft.m_91087_().f_91073_.m_9598_(), List.of(recipe));
        collection.m_100499_(page.m_100442_());
        BetterRecipeBook.pinnedRecipeManager.addOrRemoveFavourite(collection);
        ((RecipeBookComponentAccessor)book).updateCollectionsInvoker(false);
    }
}

