/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.brewingstand;

import java.util.List;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.brewingstand.PlatformPotionUtil;
import marsh.town.brb.generic.GenericRecipe;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;

public class BrewableResult
implements GenericRecipe {
    public PotionBrewing.Mix<?> recipe;
    public ResourceLocation input;

    public BrewableResult(PotionBrewing.Mix<?> recipe) {
        this.recipe = recipe;
        this.input = BuiltInRegistries.f_256980_.m_7981_((Object)PlatformPotionUtil.getFrom(recipe));
    }

    public boolean hasIngredient(List<Slot> slots) {
        for (ItemStack itemStack : PlatformPotionUtil.getIngredient(this.recipe).m_43908_()) {
            for (Slot slot : slots) {
                if (!itemStack.m_41720_().equals(slot.m_7993_().m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack inputAsItemStack(BRBBookCategories.Category category) {
        Potion inputPotion = PlatformPotionUtil.getFrom(this.recipe);
        ResourceLocation identifier = BuiltInRegistries.f_256980_.m_7981_((Object)inputPotion);
        ItemStack inputStack = category.getItemIcons().get(0).m_41777_();
        inputStack.m_41784_().m_128359_("Potion", identifier.toString());
        return inputStack;
    }

    public boolean hasInput(BRBBookCategories.Category category, List<Slot> slots) {
        ItemStack inputStack = this.inputAsItemStack(category);
        for (Slot slot : slots) {
            ItemStack itemStack = slot.m_7993_();
            if (inputStack.m_41783_() == null) {
                return false;
            }
            if (!inputStack.m_41783_().equals((Object)itemStack.m_41783_()) || !inputStack.m_41720_().equals(itemStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaterials(BRBBookCategories.Category category, List<Slot> slots) {
        boolean hasIngredient = this.hasIngredient(slots);
        boolean hasInput = this.hasInput(category, slots);
        return hasIngredient && hasInput;
    }

    @Override
    public ResourceLocation id() {
        return BuiltInRegistries.f_256980_.m_7981_((Object)PlatformPotionUtil.getTo(this.recipe));
    }

    public Component getHoverName(BRBBookCategories.Category category) {
        ItemStack ingredient = PotionUtils.m_43549_((ItemStack)category.getItemIcons().get(0).m_41777_(), (Potion)PlatformPotionUtil.getTo(this.recipe));
        return ingredient.m_41786_();
    }

    @Override
    public ItemStack getResult(RegistryAccess registryAccess, BRBBookCategories.Category category) {
        return PotionUtils.m_43549_((ItemStack)category.getItemIcons().get(0).m_41777_(), (Potion)PlatformPotionUtil.getTo(this.recipe));
    }

    @Override
    public String getSearchString(BRBBookCategories.Category category) {
        return this.getHoverName(category).getString();
    }
}

