/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.brewingstand;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.brewingstand.BrewableRecipeButton;
import marsh.town.brb.brewingstand.BrewableResult;
import marsh.town.brb.brewingstand.BrewingRecipeCollection;
import marsh.town.brb.brewingstand.PlatformPotionUtil;
import marsh.town.brb.generic.GenericRecipeBookComponent;
import marsh.town.brb.generic.GenericRecipePage;
import marsh.town.brb.interfaces.IPinningComponent;
import marsh.town.brb.loaders.PotionLoader;
import marsh.town.brb.mixins.accessors.BrewingStandMenuAccessor;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.ClientInventoryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BrewingRecipeBookComponent
extends GenericRecipeBookComponent<BrewingStandMenu, BrewingRecipeCollection, BrewableResult>
implements IPinningComponent<BrewingRecipeCollection> {
    private static final Component ONLY_CRAFTABLES_TOOLTIP = Component.m_237115_((String)"brb.gui.togglePotions.brewable");

    @Override
    public void init(int parentWidth, int parentHeight, Minecraft client, boolean narrow, BrewingStandMenu menu, Consumer<ItemStack> onGhostRecipeUpdate, RegistryAccess registryAccess) {
        super.init(parentWidth, parentHeight, client, narrow, menu, onGhostRecipeUpdate, registryAccess);
        this.recipesPage = new GenericRecipePage(registryAccess, () -> new BrewableRecipeButton(registryAccess, () -> BRBBookSettings.isFiltering(this.getRecipeBookType())));
        this.initVisuals();
        this.ghostRecipe.setRenderingPredicate((type, ingredient) -> {
            ItemStack slot = ((Slot)menu.f_38839_.get(ingredient.getContainerSlot())).m_7993_();
            switch (type) {
                case ITEM: 
                case BACKGROUND: {
                    ItemStack ghost;
                    ItemStack itemStack = ghost = ingredient.getContainerSlot() == BrewingStandMenuAccessor.getBOTTLE_SLOT_START() ? ingredient.getOwner().getBySlot(1).getItem() : ingredient.getItem();
                    if (ingredient.getContainerSlot() >= BrewingStandMenuAccessor.getBOTTLE_SLOT_START() && ingredient.getContainerSlot() <= BrewingStandMenuAccessor.getBOTTLE_SLOT_END()) {
                        Potion ghostPotion;
                        if (!(slot.m_41720_() instanceof PotionItem)) {
                            return true;
                        }
                        Potion slotPotion = PotionUtils.m_43579_((ItemStack)slot);
                        return !slotPotion.equals(ghostPotion = PotionUtils.m_43579_((ItemStack)ghost));
                    }
                    return !slot.m_150930_(ghost.m_41720_());
                }
                case TOOLTIP: {
                    return slot.m_41619_();
                }
            }
            return true;
        });
    }

    public ItemStack getInputStack(BrewableResult result) {
        Potion inputPotion = PlatformPotionUtil.getFrom(result.recipe);
        Ingredient ingredient = PlatformPotionUtil.getIngredient(result.recipe);
        ResourceLocation identifier = BuiltInRegistries.f_256980_.m_7981_((Object)inputPotion);
        ItemStack inputStack = this.selectedTab.getCategory() == BetterRecipeBook.BREWING_SPLASH_POTION ? new ItemStack((ItemLike)Items.f_42736_) : (this.selectedTab.getCategory() == BetterRecipeBook.BREWING_LINGERING_POTION ? new ItemStack((ItemLike)Items.f_42739_) : new ItemStack((ItemLike)Items.f_42589_));
        inputStack.m_41784_().m_128359_("Potion", identifier.toString());
        return inputStack;
    }

    public void setupGhostRecipe(BrewableResult result, List<Slot> slots) {
        this.ghostRecipe.addIngredient(BrewingStandMenuAccessor.getINGREDIENT_SLOT(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{PlatformPotionUtil.getIngredient(result.recipe).m_43908_()[0]}), slots.get((int)BrewingStandMenuAccessor.getINGREDIENT_SLOT()).f_40220_, slots.get((int)BrewingStandMenuAccessor.getINGREDIENT_SLOT()).f_40221_);
        assert (this.selectedTab != null);
        ItemStack inputStack = result.inputAsItemStack(this.selectedTab.getCategory());
        for (int i = BrewingStandMenuAccessor.getBOTTLE_SLOT_START(); i <= BrewingStandMenuAccessor.getBOTTLE_SLOT_END(); ++i) {
            this.ghostRecipe.addIngredient(i, Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputStack}), slots.get((int)i).f_40220_, slots.get((int)i).f_40221_);
        }
    }

    @Override
    protected List<BrewingRecipeCollection> getCollectionsForCategory() {
        ArrayList<BrewingRecipeCollection> results = new ArrayList<BrewingRecipeCollection>();
        BRBBookCategories.Category category = this.selectedTab.getCategory();
        for (BrewableResult potion : PotionLoader.POTIONS) {
            results.add(new BrewingRecipeCollection(List.of(potion), (BrewingStandMenu)this.menu, this.registryAccess, category));
        }
        return results;
    }

    @Override
    public Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    @Override
    public BRBHelper.Book getRecipeBookType() {
        return BetterRecipeBook.BREWING;
    }

    @Override
    public void handlePlaceRecipe() {
        BrewableResult result = (BrewableResult)this.recipesPage.getCurrentClickedRecipe();
        if (result == null) {
            return;
        }
        this.ghostRecipe.clear();
        if (!result.hasMaterials(this.selectedTab.getCategory(), (List<Slot>)((BrewingStandMenu)this.menu).f_38839_)) {
            this.setupGhostRecipe(result, (List<Slot>)((BrewingStandMenu)this.menu).f_38839_);
            return;
        }
        ItemStack inputStack = this.getInputStack(result);
        Ingredient ingredient = PlatformPotionUtil.getIngredient(result.recipe);
        int slotIndex = 0;
        int usedInputSlots = 0;
        for (Slot slot : ((BrewingStandMenu)this.menu).f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            assert (inputStack.m_41783_() != null);
            if (inputStack.m_41783_().equals((Object)itemStack.m_41783_()) && inputStack.m_41720_().equals(itemStack.m_41720_())) {
                if (usedInputSlots <= 2) {
                    assert (Minecraft.m_91087_().f_91072_ != null);
                    ClientInventoryUtil.storeItem(-1, i -> i > 4);
                    Minecraft.m_91087_().f_91072_.m_171799_(((BrewingStandMenu)this.menu).f_38840_, ((BrewingStandMenu)this.menu).m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    Minecraft.m_91087_().f_91072_.m_171799_(((BrewingStandMenu)this.menu).f_38840_, ((BrewingStandMenu)this.menu).m_38853_((int)usedInputSlots).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    ClientInventoryUtil.storeItem(-1, i -> i > 4);
                    ++usedInputSlots;
                }
            } else if (ingredient.m_43908_()[0].m_41720_().equals(slot.m_7993_().m_41720_())) {
                assert (Minecraft.m_91087_().f_91072_ != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                Minecraft.m_91087_().f_91072_.m_171799_(((BrewingStandMenu)this.menu).f_38840_, ((BrewingStandMenu)this.menu).m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                Minecraft.m_91087_().f_91072_.m_171799_(((BrewingStandMenu)this.menu).f_38840_, ((BrewingStandMenu)this.menu).m_38853_((int)3).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            }
            ++slotIndex;
        }
        this.updateCollections(false);
    }

    public void recipesUpdated() {
        this.updateCollections(false);
    }
}

