/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.generic.GenericRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class GenericGhostRecipe<R extends GenericRecipe> {
    @Nullable
    protected Consumer<ItemStack> onGhostUpdate;
    @Nullable
    protected R recipe;
    protected final List<GenericGhostIngredient> ingredients = Lists.newArrayList();
    protected float time;
    protected RegistryAccess registryAccess;
    @Nullable
    private BiPredicate<GhostRenderType, GenericGhostIngredient> renderingPredicate;

    public GenericGhostRecipe(@Nullable Consumer<ItemStack> onGhostUpdate, RegistryAccess registryAccess) {
        this.onGhostUpdate = onGhostUpdate;
        this.registryAccess = registryAccess;
    }

    public void setRenderingPredicate(@Nullable BiPredicate<GhostRenderType, GenericGhostIngredient> renderingPredicate) {
        this.renderingPredicate = renderingPredicate;
    }

    public <T extends AbstractContainerMenu> void setDefaultRenderingPredicate(T menu) {
        this.setRenderingPredicate((type, ingredient) -> {
            ItemStack slot = ((Slot)menu.f_38839_.get(ingredient.getContainerSlot())).m_7993_();
            switch (type) {
                case ITEM: 
                case BACKGROUND: 
                case TOOLTIP: {
                    return slot.m_41619_();
                }
            }
            return true;
        });
    }

    public ItemStack getCurrentResult(BRBBookCategories.Category category) {
        if (this.recipe == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.recipe.getResult(this.registryAccess, category);
        return itemStack.m_41777_();
    }

    public void clear() {
        this.recipe = null;
        this.ingredients.clear();
        this.time = 0.0f;
    }

    public void addIngredient(int containerSlot, Ingredient ingredient, int i, int j) {
        this.ingredients.add(new GenericGhostIngredient(containerSlot, ingredient, i, j));
    }

    public GenericGhostIngredient get(int i) {
        return this.ingredients.get(i);
    }

    public int size() {
        return this.ingredients.size();
    }

    @Nullable
    public R getRecipe() {
        return this.recipe;
    }

    public void setRecipe(@Nullable R recipe) {
        this.recipe = recipe;
    }

    public void render(GuiGraphics guiGraphics, Minecraft minecraft, int i, int j, boolean bl, float f, BRBBookCategories.Category category) {
        if (!Screen.m_96637_()) {
            this.time += f;
            if (this.onGhostUpdate != null && this.recipe != null) {
                this.onGhostUpdate.accept(this.getCurrentResult(category));
            }
        }
        for (int k = 0; k < this.ingredients.size(); ++k) {
            GenericGhostIngredient ghostIngredient = this.ingredients.get(k);
            boolean shouldRenderBackground = this.renderingPredicate != null && this.renderingPredicate.test(GhostRenderType.BACKGROUND, ghostIngredient);
            boolean shouldRenderItem = this.renderingPredicate != null && this.renderingPredicate.test(GhostRenderType.ITEM, ghostIngredient);
            int l = ghostIngredient.getX() + i;
            int m = ghostIngredient.getY() + j;
            if (shouldRenderBackground) {
                if (k == 0 && bl) {
                    guiGraphics.m_280509_(l - 4, m - 4, l + 20, m + 20, 0x30FF0000);
                } else {
                    guiGraphics.m_280509_(l, m, l + 16, m + 16, 0x30FF0000);
                }
            }
            ItemStack itemStack = ghostIngredient.getItem();
            if (shouldRenderItem) {
                guiGraphics.m_280203_(itemStack, l, m);
            }
            if (shouldRenderBackground) {
                guiGraphics.m_285944_(RenderType.m_285811_(), l, m, l + 16, m + 16, 0x30FFFFFF);
            }
            if (k != 0) continue;
            guiGraphics.m_280370_(minecraft.f_91062_, itemStack, l, m);
        }
    }

    public GenericGhostIngredient getBySlot(int i) {
        for (GenericGhostIngredient ingredient : this.ingredients) {
            if (ingredient.getContainerSlot() != i) continue;
            return ingredient;
        }
        return null;
    }

    public void drawTooltip(GuiGraphics gui, int x, int y, int mouseX, int mouseY) {
        ItemStack itemStack = null;
        for (GenericGhostIngredient ingredient : this.ingredients) {
            int j = ingredient.getX() + x;
            int k = ingredient.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16 || this.renderingPredicate != null && !this.renderingPredicate.test(GhostRenderType.TOOLTIP, ingredient)) continue;
            itemStack = ingredient.getItem();
        }
        if (itemStack != null && Minecraft.m_91087_().f_91080_ != null) {
            gui.m_280666_(Minecraft.m_91087_().f_91062_, Screen.m_280152_((Minecraft)Minecraft.m_91087_(), itemStack), mouseX, mouseY);
        }
    }

    public class GenericGhostIngredient {
        private final Ingredient ingredient;
        private final int x;
        private final int y;
        private final int containerSlot;

        public GenericGhostIngredient(int containerSlot, Ingredient ingredient, int i, int j) {
            this.containerSlot = containerSlot;
            this.ingredient = ingredient;
            this.x = i;
            this.y = j;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public ItemStack getItem() {
            ItemStack[] itemStacks = this.ingredient.m_43908_();
            return itemStacks.length == 0 ? ItemStack.f_41583_ : itemStacks[Mth.m_14143_((float)(GenericGhostRecipe.this.time / 30.0f)) % itemStacks.length];
        }

        public int getContainerSlot() {
            return this.containerSlot;
        }

        public GenericGhostRecipe<R> getOwner() {
            return GenericGhostRecipe.this;
        }
    }

    public static enum GhostRenderType {
        ITEM,
        BACKGROUND,
        TOOLTIP;

    }
}

