/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.pins.Pinnable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public abstract class GenericRecipeBookCollection<R extends GenericRecipe, M extends AbstractContainerMenu>
implements Pinnable {
    protected final RegistryAccess registryAccess;
    protected List<R> recipes;
    protected M menu;

    protected GenericRecipeBookCollection(List<? extends R> list, M menu, RegistryAccess registryAccess) {
        this.menu = menu;
        this.recipes = ImmutableList.copyOf(list);
        this.registryAccess = registryAccess;
    }

    public List<R> getRecipes() {
        return this.recipes;
    }

    protected abstract List<R> getDisplayRecipes(boolean var1);

    @Override
    public boolean has(ResourceLocation resourceLocation) {
        for (GenericRecipe recipe : this.getRecipes()) {
            if (!recipe.id().equals((Object)resourceLocation)) continue;
            return true;
        }
        return false;
    }

    public R getFirst() {
        return (R)((GenericRecipe)this.getRecipes().get(0));
    }

    protected abstract boolean atleastOneCraftable(NonNullList<Slot> var1);
}

