/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.generic.BRBGroupButtonWidget;
import marsh.town.brb.generic.GenericClientRecipeBook;
import marsh.town.brb.generic.GenericGhostRecipe;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.GenericRecipeButton;
import marsh.town.brb.generic.GenericRecipePage;
import marsh.town.brb.interfaces.IPinningComponent;
import marsh.town.brb.interfaces.ISettingsButton;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericRecipeBookComponent<M extends AbstractContainerMenu, C extends GenericRecipeBookCollection<R, M>, R extends GenericRecipe>
implements Renderable,
NarratableEntry,
GuiEventListener,
ISettingsButton,
RecipeShownListener,
IPinningComponent<C> {
    protected static final Component SEARCH_HINT = RecipeBookComponentAccessor.getSEARCH_HINT();
    protected static final Component ALL_RECIPES_TOOLTIP = RecipeBookComponentAccessor.getALL_RECIPES_TOOLTIP();
    boolean visible;
    protected boolean ignoreTextInput;
    protected Minecraft minecraft;
    protected EditBox searchBox;
    private String lastSearch;
    protected int xOffset;
    protected boolean widthTooNarrow;
    protected int width;
    protected int height;
    protected M menu;
    protected final StackedContents stackedContents = new StackedContents();
    protected StateSwitchingButton filterButton;
    protected ImageButton settingsButton;
    public GenericRecipePage<M, C, R> recipesPage;
    protected final List<BRBGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    public BRBGroupButtonWidget selectedTab;
    protected GenericClientRecipeBook book;
    protected RecipeManager recipeManager;
    private boolean doubleRefresh = true;
    protected RegistryAccess registryAccess;
    @Nullable
    public GenericGhostRecipe<R> ghostRecipe;

    protected GenericRecipeBookComponent() {
    }

    public abstract Component getRecipeFilterName();

    public abstract BRBHelper.Book getRecipeBookType();

    public void init(int parentWidth, int parentHeight, Minecraft client, boolean narrow, M menu, RegistryAccess registryAccess) {
        this.init(parentWidth, parentHeight, client, narrow, menu, null, registryAccess);
    }

    public void init(int width, int height, Minecraft minecraft, boolean widthNarrow, M menu, @Nullable Consumer<ItemStack> onGhostRecipeUpdate, RegistryAccess registryAccess) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.menu = menu;
        this.widthTooNarrow = widthNarrow;
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        this.minecraft.f_91074_.f_36096_ = menu;
        this.setVisible(BRBBookSettings.isOpen(this.getRecipeBookType()));
        this.book = new GenericClientRecipeBook();
        this.registryAccess = registryAccess;
        this.ghostRecipe = new GenericGhostRecipe(onGhostRecipeUpdate, registryAccess);
    }

    public void initVisuals() {
        this.xOffset = BetterRecipeBook.config.keepCentered ? (this.widthTooNarrow ? 0 : 162) : (this.widthTooNarrow ? 0 : 86);
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.stackedContents.m_36453_();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        this.minecraft.f_91074_.m_150109_().m_36010_(this.stackedContents);
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        Objects.requireNonNull(this.minecraft.f_91062_);
        Font font = this.minecraft.f_91062_;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.searchBox = new EditBox(font, i + 25, j + 13, 81, 9 + 5, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_257771_(SEARCH_HINT);
        this.settingsButton = this.createSettingsButton(i, j);
        this.recipesPage.initialize(this.minecraft, i, j, this.menu, this.xOffset);
        this.tabButtons.clear();
        this.filterButton = new StateSwitchingButton(i + 110, j + 12, 26, 16, BRBBookSettings.isFiltering(this.getRecipeBookType()));
        this.updateFilterButtonTooltip();
        this.filterButton.m_94624_(152, 41, 28, 18, RecipeBookComponentAccessor.getRECIPE_BOOK_LOCATION());
        List<BRBBookCategories.Category> categories = BRBBookCategories.getCategories(this.getRecipeBookType());
        if (categories == null) {
            throw new NullPointerException("Book category not registered");
        }
        for (BRBBookCategories.Category category : categories) {
            this.tabButtons.add(new BRBGroupButtonWidget(category));
        }
        if (this.selectedTab != null) {
            this.selectedTab = this.tabButtons.stream().filter(button -> button.getCategory().equals(this.selectedTab.getCategory())).findFirst().orElse(null);
        }
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
        }
        this.selectedTab.m_94635_(true);
        this.updateCollections(false);
        this.refreshTabButtons();
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (this.doubleRefresh) {
            this.updateCollections(true);
            this.doubleRefresh = false;
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int blitX = (this.width - 147) / 2 - this.xOffset;
        int blitY = (this.height - 166) / 2;
        gui.m_280218_(BRBTextures.RECIPE_BOOK_BACKGROUND_TEXTURE, blitX, blitY, 1, 1, 147, 166);
        this.searchBox.m_88315_(gui, mouseX, mouseY, delta);
        for (BRBGroupButtonWidget widget : this.tabButtons) {
            widget.m_88315_(gui, mouseX, mouseY, delta);
        }
        this.filterButton.m_88315_(gui, mouseX, mouseY, delta);
        ISettingsButton.super.renderSettingsButton(this.settingsButton, gui, mouseX, mouseY, delta);
        this.recipesPage.render(gui, blitX, blitY, mouseX, mouseY, delta);
        gui.m_280168_().m_85849_();
    }

    public boolean m_7933_(int i, int j, int k) {
        this.ignoreTextInput = false;
        if (!this.isVisible() || this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_5833_()) {
            return false;
        }
        if (i == 256 && !this.isOffsetNextToMainGUI()) {
            this.setVisible(false);
            return true;
        }
        if (this.searchBox.m_7933_(i, j, k)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.searchBox.m_93696_() && this.searchBox.m_94213_() && i != 256) {
            return true;
        }
        if (this.minecraft.f_91066_.f_92098_.m_90832_(i, j) && !this.searchBox.m_93696_()) {
            this.ignoreTextInput = true;
            this.searchBox.m_93692_(true);
            return true;
        }
        if (BetterRecipeBook.PIN_MAPPING.m_90832_(i, j) && BetterRecipeBook.config.enablePinning) {
            for (GenericRecipeButton resultButton : this.recipesPage.buttons) {
                if (!resultButton.m_198029_()) continue;
                BetterRecipeBook.pinnedRecipeManager.addOrRemoveFavourite(resultButton.getCollection());
                this.updateCollections(false);
                return true;
            }
        }
        return false;
    }

    public abstract void handlePlaceRecipe();

    public boolean m_7920_(int i, int j, int k) {
        this.ignoreTextInput = false;
        return super.m_7920_(i, j, k);
    }

    public boolean m_5534_(char c, int i) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.isVisible() || this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_5833_()) {
            return false;
        }
        if (this.searchBox.m_5534_(c, i)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.m_5534_(c, i);
    }

    private void checkSearchStringUpdate() {
        String string = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        this.pirateSpeechForThePeople(string);
        if (!string.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = string;
        }
    }

    protected void updateCollections(boolean b) {
        if (this.selectedTab == null) {
            return;
        }
        if (this.searchBox == null) {
            return;
        }
        ArrayList<C> results = new ArrayList<C>(this.getCollectionsForCategory());
        String string = this.searchBox.m_94155_();
        if (!string.isEmpty()) {
            results.removeIf(collection -> !collection.getFirst().getSearchString(this.selectedTab.getCategory()).toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (BRBBookSettings.isFiltering(this.getRecipeBookType())) {
            results.removeIf(result -> !result.atleastOneCraftable((NonNullList<Slot>)((AbstractContainerMenu)this.menu).f_38839_));
        }
        this.betterRecipeBook$sortByPinsInPlace(results);
        this.recipesPage.setResults(results, b, this.selectedTab.getCategory());
    }

    private void pirateSpeechForThePeople(String string) {
        if ("excitedze".equals(string)) {
            LanguageManager languageManager = this.minecraft.m_91102_();
            String string2 = "en_pt";
            LanguageInfo languageInfo = languageManager.m_118976_("en_pt");
            if (languageInfo == null || languageManager.m_264236_().equals("en_pt")) {
                return;
            }
            languageManager.m_264110_("en_pt");
            this.minecraft.f_91066_.f_92075_ = "en_pt";
            this.minecraft.m_91391_();
            this.minecraft.f_91066_.m_92169_();
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return this.isVisible() ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    protected void setVisible(boolean visible) {
        BRBBookSettings.setOpen(this.getRecipeBookType(), visible);
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean hasClickedOutside(double d, double e, int i, int j, int k, int l, int m) {
        if (!this.isVisible()) {
            return true;
        }
        boolean bl = d < (double)i || e < (double)j || d >= (double)(i + k) || e >= (double)(j + l);
        boolean bl2 = (double)(i - 147) < d && d < (double)i && (double)j < e && e < (double)(j + l);
        return bl && !bl2;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.recipesPage.mouseClicked(mouseX, mouseY, button, (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166)) {
            this.handlePlaceRecipe();
            return true;
        }
        if (this.searchBox.m_6375_(mouseX, mouseY, button)) {
            this.searchBox.m_93692_(true);
            this.ignoreTextInput = true;
            return true;
        }
        this.searchBox.m_93692_(false);
        this.ignoreTextInput = false;
        if (this.filterButton.m_6375_(mouseX, mouseY, button)) {
            boolean bl = this.toggleFiltering();
            this.filterButton.m_94635_(bl);
            this.updateFilterButtonTooltip();
            this.updateCollections(false);
            return true;
        }
        if (ISettingsButton.super.settingsButtonMouseClicked(this.settingsButton, mouseX, mouseY, button)) {
            return true;
        }
        Iterator<BRBGroupButtonWidget> tabButtonsIter = this.tabButtons.iterator();
        if (!tabButtonsIter.hasNext()) {
            return false;
        }
        BRBGroupButtonWidget widget = tabButtonsIter.next();
        while (!widget.m_6375_(mouseX, mouseY, button)) {
            if (!tabButtonsIter.hasNext()) {
                return false;
            }
            widget = tabButtonsIter.next();
        }
        if (this.selectedTab != widget) {
            if (this.selectedTab != null) {
                this.selectedTab.m_94635_(false);
            }
            this.selectedTab = widget;
            this.selectedTab.m_94635_(true);
            this.updateCollections(true);
        }
        return false;
    }

    protected boolean toggleFiltering() {
        boolean bl = !BRBBookSettings.isFiltering(this.getRecipeBookType());
        BRBBookSettings.setFiltering(this.getRecipeBookType(), bl);
        return bl;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }

    protected void updateFilterButtonTooltip() {
        this.filterButton.m_257544_(this.filterButton.m_94620_() ? Tooltip.m_257550_((Component)this.getRecipeFilterName()) : Tooltip.m_257550_((Component)ALL_RECIPES_TOOLTIP));
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int j = this.isVisible() && !this.widthTooNarrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return j;
    }

    public void drawTooltip(GuiGraphics gui, int x, int y, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.recipesPage.overlayIsVisible()) {
            this.recipesPage.drawTooltip(gui, mouseX, mouseY);
            ISettingsButton.super.renderSettingsButtonTooltip(this.settingsButton, gui, mouseX, mouseY);
        }
        this.ghostRecipe.drawTooltip(gui, x, y, mouseX, mouseY);
    }

    protected void refreshTabButtons() {
        int i = (this.width - 147) / 2 - this.xOffset - 30;
        int j = (this.height - 166) / 2 + 3;
        int l = 0;
        for (BRBGroupButtonWidget button : this.tabButtons) {
            BRBBookCategories.Category category = button.getCategory();
            if (category.getType() == BRBBookCategories.Category.Type.SEARCH) {
                button.f_93624_ = true;
            }
            button.m_264152_(i, j + 27 * l++);
        }
    }

    public void renderGhostRecipe(GuiGraphics guiGraphics, int x, int y, boolean bl, float delta) {
        if (this.selectedTab == null || this.ghostRecipe == null) {
            return;
        }
        this.ghostRecipe.render(guiGraphics, this.minecraft, x, y, bl, delta, this.selectedTab.getCategory());
    }

    protected abstract List<C> getCollectionsForCategory();

    public void m_7262_(List<Recipe<?>> list) {
    }
}

