/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.pins.Pinnable;
import marsh.town.brb.mixins.accessors.KeyMappingAccessor;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class GenericRecipeButton<C extends GenericRecipeBookCollection<R, M>, R extends GenericRecipe, M extends AbstractContainerMenu>
extends AbstractWidget {
    private final Supplier<Boolean> filteringSupplier;
    protected C collection;
    protected M menu;
    protected float time;
    protected int currentIndex;
    protected RegistryAccess registryAccess;
    protected BRBBookCategories.Category category;

    public GenericRecipeButton(RegistryAccess registryAccess, Supplier<Boolean> filteringSupplier) {
        super(0, 0, 25, 25, CommonComponents.f_237098_);
        this.registryAccess = registryAccess;
        this.filteringSupplier = filteringSupplier;
    }

    public void showCollection(C collection, M smithingMenu, BRBBookCategories.Category category) {
        this.collection = collection;
        this.menu = smithingMenu;
        this.category = category;
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        List<R> list;
        if (!Screen.m_96637_()) {
            this.time += delta;
        }
        if ((list = this.getOrderedRecipes()).isEmpty()) {
            return;
        }
        this.currentIndex = Mth.m_14143_((float)(this.time / 30.0f)) % list.size();
        int k = 29;
        if (!((GenericRecipeBookCollection)this.collection).atleastOneCraftable((NonNullList<Slot>)((AbstractContainerMenu)this.menu).f_38839_)) {
            k += 25;
        }
        int l = 206;
        gui.m_280168_().m_85836_();
        gui.m_280218_(BRBTextures.RECIPE_BOOK_BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), k, l, this.f_93618_, this.f_93619_);
        ItemStack result = this.getCurrentDisplayedRecipe().getResult(this.registryAccess, this.category);
        int offset = 4;
        gui.m_280203_(result, this.m_252754_() + offset, this.m_252907_() + offset);
        gui.m_280168_().m_85849_();
        if (BetterRecipeBook.config.enablePinning && BetterRecipeBook.pinnedRecipeManager.has((Pinnable)this.collection)) {
            gui.m_280163_(BRBTextures.RECIPE_BOOK_OVERLAY_PIN_SPRITE, this.m_252754_() - 3, this.m_252907_() - 3, 0.0f, 0.0f, this.f_93618_ + 3, this.f_93619_ + 3, 31, 31);
        }
    }

    public R getCurrentDisplayedRecipe() {
        List<R> list = this.getOrderedRecipes();
        return (R)((GenericRecipe)list.get(this.currentIndex));
    }

    public boolean isOnlyOption() {
        return this.getOrderedRecipes().size() == 1;
    }

    public List<R> getOrderedRecipes() {
        List list = ((GenericRecipeBookCollection)this.getCollection()).getDisplayRecipes(true);
        if (!this.filteringSupplier.get().booleanValue()) {
            list.addAll(((GenericRecipeBookCollection)this.collection).getDisplayRecipes(false));
        }
        return list;
    }

    public C getCollection() {
        return this.collection;
    }

    public void m_168797_(NarrationElementOutput builder) {
    }

    public int m_5711_() {
        return 25;
    }

    protected boolean m_7972_(int i) {
        return i == 0 || i == 1;
    }

    public List<Component> getTooltipText() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.getCurrentDisplayedRecipe().getResult(this.registryAccess, this.category).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.f_256752_));
        this.addPinTooltip(list);
        return list;
    }

    public void addPinTooltip(List<Component> list) {
        list.add((Component)Component.m_237119_());
        if (BetterRecipeBook.config.enablePinning) {
            if (BetterRecipeBook.pinnedRecipeManager.has((Pinnable)this.collection)) {
                list.add((Component)Component.m_237110_((String)"brb.gui.pin.remove", (Object[])new Object[]{((KeyMappingAccessor)BetterRecipeBook.PIN_MAPPING).getKey().m_84875_()}));
            } else {
                list.add((Component)Component.m_237110_((String)"brb.gui.pin.add", (Object[])new Object[]{((KeyMappingAccessor)BetterRecipeBook.PIN_MAPPING).getKey().m_84875_()}));
            }
        }
    }
}

