/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.generic.GenericRecipe;
import marsh.town.brb.generic.GenericRecipeBookCollection;
import marsh.town.brb.generic.GenericRecipeButton;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class GenericRecipePage<M extends AbstractContainerMenu, C extends GenericRecipeBookCollection<R, M>, R extends GenericRecipe> {
    protected final RegistryAccess registryAccess;
    protected M menu;
    protected Minecraft minecraft;
    protected int parentLeft;
    protected int parentTop;
    protected StateSwitchingButton forwardButton;
    protected StateSwitchingButton backButton;
    protected List<C> recipeCollections = ImmutableList.of();
    protected C lastClickedRecipeCollection;
    protected R lastClickedRecipe;
    protected BRBBookCategories.Category category;
    protected int totalPages;
    protected int currentPage;
    public final List<GenericRecipeButton<C, R, M>> buttons = Lists.newArrayListWithCapacity((int)20);
    protected GenericRecipeButton<C, R, M> hoveredButton;

    public GenericRecipePage(RegistryAccess registryAccess, Supplier<GenericRecipeButton<C, R, M>> recipeButtonSupplier) {
        this.registryAccess = registryAccess;
        for (int i = 0; i < 20; ++i) {
            this.buttons.add(recipeButtonSupplier.get());
        }
    }

    protected void initialize(Minecraft client, int parentLeft, int parentTop, M menu, int leftOffset) {
        this.minecraft = client;
        this.menu = menu;
        this.parentLeft = parentLeft;
        this.parentTop = parentTop;
        this.forwardButton = new StateSwitchingButton(parentLeft + 93, parentTop + 137, 12, 17, false);
        this.forwardButton.m_94624_(1, 208, 13, 18, RecipeBookComponentAccessor.getRECIPE_BOOK_LOCATION());
        this.backButton = new StateSwitchingButton(parentLeft + 38, parentTop + 137, 12, 17, true);
        this.backButton.m_94624_(1, 208, 13, 18, RecipeBookComponentAccessor.getRECIPE_BOOK_LOCATION());
        for (int k = 0; k < this.buttons.size(); ++k) {
            this.buttons.get(k).m_264152_(parentLeft + 11 + 25 * (k % 5), parentTop + 31 + 25 * (k / 5));
        }
    }

    protected boolean overlayMouseClicked(double mouseX, double mouseY, int button, int j, int k, int l, int m) {
        return false;
    }

    protected void initOverlay(C recipeCollection, int x, int y, RegistryAccess registryAccess) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, int j, int k, int l, int m) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeCollection = null;
        if (this.overlayIsVisible() && this.overlayMouseClicked(mouseX, mouseY, button, j, k, l, m)) {
            return true;
        }
        if (this.forwardButton.m_6375_(mouseX, mouseY, button)) {
            if (++this.currentPage >= this.totalPages) {
                this.currentPage = BetterRecipeBook.config.scrolling.scrollAround ? 0 : this.totalPages - 1;
            }
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.m_6375_(mouseX, mouseY, button)) {
            if (--this.currentPage < 0) {
                this.currentPage = BetterRecipeBook.config.scrolling.scrollAround ? this.totalPages - 1 : 0;
            }
            this.updateButtonsForPage();
            return true;
        }
        for (GenericRecipeButton<C, R, M> recipeButton : this.buttons) {
            if (!recipeButton.m_6375_(mouseX, mouseY, button)) continue;
            if (button == 0) {
                this.lastClickedRecipe = recipeButton.getCurrentDisplayedRecipe();
                this.lastClickedRecipeCollection = recipeButton.getCollection();
            } else if (button == 1 && !this.overlayIsVisible() && !recipeButton.isOnlyOption()) {
                this.initOverlay(recipeButton.getCollection(), this.parentLeft, this.parentTop, this.registryAccess);
            }
            return true;
        }
        return false;
    }

    public void updateButtonsForPage() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.buttons.size(); ++j) {
            GenericRecipeButton<GenericRecipeBookCollection, R, M> button = this.buttons.get(j);
            if (i + j < this.recipeCollections.size()) {
                GenericRecipeBookCollection output = (GenericRecipeBookCollection)this.recipeCollections.get(i + j);
                button.showCollection(output, this.menu, this.category);
                button.f_93624_ = true;
                continue;
            }
            button.f_93624_ = false;
        }
        this.updateArrowButtons();
    }

    protected boolean overlayIsVisible() {
        return false;
    }

    protected void render(GuiGraphics gui, int blitX, int blitY, int mouseX, int mouseY, float delta) {
        if (BetterRecipeBook.queuedScroll != 0 && BetterRecipeBook.config.scrolling.enableScrolling) {
            if (this.totalPages > 1) {
                this.currentPage += BetterRecipeBook.queuedScroll;
                if (this.currentPage >= this.totalPages) {
                    this.currentPage = BetterRecipeBook.config.scrolling.scrollAround ? this.currentPage % this.totalPages : this.totalPages - 1;
                } else if (this.currentPage < 0) {
                    this.currentPage = BetterRecipeBook.config.scrolling.scrollAround ? this.currentPage % this.totalPages + this.totalPages : 0;
                }
                this.updateButtonsForPage();
            }
            BetterRecipeBook.queuedScroll = 0;
        }
        if (this.totalPages > 1) {
            String string = this.currentPage + 1 + "/" + this.totalPages;
            int width = this.minecraft.f_91062_.m_92895_(string);
            gui.m_280056_(this.minecraft.f_91062_, string, blitX - width / 2 + 73, blitY + 141, -1, false);
        }
        this.hoveredButton = null;
        for (GenericRecipeButton<C, R, M> button : this.buttons) {
            button.m_88315_(gui, mouseX, mouseY, delta);
            if (!button.f_93624_ || !button.m_198029_()) continue;
            this.hoveredButton = button;
        }
        this.backButton.m_88315_(gui, mouseX, mouseY, delta);
        this.forwardButton.m_88315_(gui, mouseX, mouseY, delta);
    }

    public void setResults(List<C> recipeCollection, boolean resetCurrentPage, BRBBookCategories.Category category) {
        this.recipeCollections = recipeCollection;
        this.category = category;
        this.totalPages = (int)Math.ceil((double)recipeCollection.size() / 20.0);
        if (this.totalPages <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    @Nullable
    public R getCurrentClickedRecipe() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public C getLastClickedRecipeCollection() {
        return this.lastClickedRecipeCollection;
    }

    protected void updateArrowButtons() {
        if (BetterRecipeBook.config.scrolling.scrollAround && this.totalPages > 1) {
            this.forwardButton.f_93624_ = true;
            this.backButton.f_93624_ = true;
        } else {
            this.forwardButton.f_93624_ = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
            this.backButton.f_93624_ = this.totalPages > 1 && this.currentPage > 0;
        }
    }

    public void drawTooltip(GuiGraphics gui, int x, int y) {
        if (this.minecraft.f_91080_ != null && this.hoveredButton != null) {
            gui.m_280666_(Minecraft.m_91087_().f_91062_, this.hoveredButton.getTooltipText(), x, y);
        }
    }
}

