/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.mixins.unlockrecipes;

import java.util.Set;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.interfaces.unlockrecipes.IMixinRecipeManager;
import marsh.town.brb.mixins.accessors.RecipeBookComponentAccessor;
import marsh.town.brb.util.RecipeMenuUtil;
import marsh.town.brb.util.RecipeUnlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Shadow
    @Final
    private RecipeManager f_104900_;
    @Unique
    private Minecraft _$minecraft = Minecraft.m_91087_();

    @Inject(method={"handleAddOrRemoveRecipes"}, at={@At(value="RETURN")})
    public void onAddOrRemoveRecipes(ClientboundRecipePacket packet, CallbackInfo ci) {
        Set<ResourceLocation> serverUnlockedRecipes = ((IMixinRecipeManager)this.f_104900_).betterRecipeBook$getServerUnlockedRecipes();
        switch (packet.m_132870_()) {
            case INIT: {
                serverUnlockedRecipes.clear();
            }
            case ADD: {
                serverUnlockedRecipes.addAll(packet.m_132865_());
                break;
            }
            case REMOVE: {
                packet.m_132865_().forEach(serverUnlockedRecipes::remove);
            }
        }
        RecipeUnlockUtil.unlockRecipesIfRequired();
    }

    @Inject(method={"handleUpdateRecipes"}, at={@At(value="RETURN")})
    public void onUpdateRecipes(ClientboundUpdateRecipesPacket packet, CallbackInfo ci) {
        RecipeUnlockUtil.unlockRecipesIfRequired();
    }

    @Inject(method={"handleContainerSetSlot"}, at={@At(value="HEAD")})
    public void onContainerSetSlot(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu;
        if (BetterRecipeBook.config.newRecipes.unlockAll && this._$minecraft.f_91074_ != null && (abstractContainerMenu = this._$minecraft.f_91074_.f_36096_) instanceof RecipeBookMenu) {
            RecipeBookMenu menu = (RecipeBookMenu)abstractContainerMenu;
            if (this._$minecraft.f_91074_.f_36096_.f_38840_ == packet.m_131991_() && (abstractContainerMenu = this._$minecraft.f_91080_) instanceof RecipeUpdateListener) {
                RecipeUpdateListener rul = (RecipeUpdateListener)abstractContainerMenu;
                if (!packet.m_131995_().m_41619_() && RecipeMenuUtil.isRecipeSlot(menu, packet.m_131994_())) {
                    ((RecipeBookComponentAccessor)rul.m_5564_()).getGhostRecipe().m_100140_();
                }
            }
        }
    }

    @Inject(method={"handlePlaceRecipe"}, at={@At(value="HEAD", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeBookComponent;setupGhostRecipe(Lnet/minecraft/world/item/crafting/Recipe;Ljava/util/List;)V")})
    public void onHandlePlaceRecipe_setupGhostRecipe(ClientboundPlaceGhostRecipePacket packet, CallbackInfo ci) {
        Screen screen = this._$minecraft.f_91080_;
        if (screen instanceof RecipeUpdateListener) {
            RecipeUpdateListener rul = (RecipeUpdateListener)screen;
            ((RecipeBookComponentAccessor)rul.m_5564_()).getGhostRecipe().m_100140_();
        }
    }
}

