/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.smithingtable;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.recipe.BRBSmithingRecipe;
import marsh.town.brb.smithingtable.SmithingRecipeCollection;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SmithingOverlayRecipeComponent
implements Renderable,
GuiEventListener {
    private final List<OverlayRecipeButton> recipeButtons = Lists.newArrayList();
    private BRBSmithingRecipe lastRecipeClicked;
    private SmithingRecipeCollection collection;
    private boolean isVisible;
    private static final ResourceLocation OVERLAY_RECIPE_SPRITE = new ResourceLocation("recipe_book/overlay_recipe");
    float time;
    private int y;
    private int x;

    public void init(SmithingRecipeCollection recipeCollection, int x, int y, RegistryAccess registryAccess) {
        this.collection = recipeCollection;
        List<BRBSmithingRecipe> lockedRecipes = recipeCollection.getDisplayRecipes(true);
        List unlockedRecipes = BRBBookSettings.isFiltering(BetterRecipeBook.SMITHING) ? Collections.emptyList() : recipeCollection.getDisplayRecipes(false);
        int lockedRecipeCount = lockedRecipes.size();
        int totalRecipeCount = lockedRecipeCount + unlockedRecipes.size();
        int columns = totalRecipeCount <= 16 ? 4 : 5;
        this.x = x + 7;
        this.y = y + 26;
        this.isVisible = true;
        this.recipeButtons.clear();
        for (int index = 0; index < totalRecipeCount; ++index) {
            boolean isCraftable = index < lockedRecipeCount;
            BRBSmithingRecipe Recipe2 = isCraftable ? lockedRecipes.get(index) : (BRBSmithingRecipe)unlockedRecipes.get(index - lockedRecipeCount);
            int buttonX = this.x + 4 + 25 * (index % columns);
            int buttonY = this.y + 5 + 25 * (index / columns);
            this.recipeButtons.add(new OverlayRecipeButton(buttonX, buttonY, Recipe2, isCraftable, registryAccess));
        }
        this.lastRecipeClicked = null;
    }

    public boolean m_6375_(double d, double e, int i) {
        if (i != 0) {
            return false;
        }
        for (OverlayRecipeButton overlayRecipeButton : this.recipeButtons) {
            if (!overlayRecipeButton.m_6375_(d, e, i)) continue;
            this.lastRecipeClicked = overlayRecipeButton.recipe;
            return true;
        }
        return false;
    }

    public boolean m_5953_(double d, double e) {
        return false;
    }

    @Nullable
    public BRBSmithingRecipe getLastRecipeClicked() {
        return this.lastRecipeClicked;
    }

    public SmithingRecipeCollection getRecipeCollection() {
        return this.collection;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.isVisible) {
            guiGraphics.m_280168_().m_85849_();
            this.time += f;
            RenderSystem.enableBlend();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
            int k = this.recipeButtons.size() <= 16 ? 4 : 5;
            int l = Math.min(this.recipeButtons.size(), k);
            int m = Mth.m_14167_((float)((float)this.recipeButtons.size() / (float)k));
            guiGraphics.m_280260_(BRBTextures.RECIPE_BOOK_BACKGROUND_TEXTURE, this.x, this.y, l * 25 + 8, m * 25 + 8, 4, 32, 32, 82, 208);
            RenderSystem.disableBlend();
            for (OverlayRecipeButton overlayRecipeButton : this.recipeButtons) {
                overlayRecipeButton.m_88315_(guiGraphics, i, j, f);
            }
        }
    }

    public static class OverlayRecipeButton
    extends AbstractWidget {
        final BRBSmithingRecipe recipe;
        private final boolean isCraftable;
        private RegistryAccess registryAccess;

        public OverlayRecipeButton(int i, int j, BRBSmithingRecipe smithableResult, boolean isCraftable, RegistryAccess registryAccess) {
            super(i, j, 200, 20, CommonComponents.f_237098_);
            this.f_93618_ = 24;
            this.f_93619_ = 24;
            this.recipe = smithableResult;
            this.isCraftable = isCraftable;
            this.registryAccess = registryAccess;
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            ResourceLocation resourceLocation = BRBTextures.RECIPE_BOOK_PLAIN_OVERLAY_SPRITE.get(this.isCraftable, this.m_198029_());
            guiGraphics.m_280163_(resourceLocation, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, 24, 24);
            guiGraphics.m_280168_().m_85836_();
            int offset = 4;
            guiGraphics.m_280203_(this.recipe.getResult(this.registryAccess, BetterRecipeBook.SMITHING_SEARCH), this.m_252754_() + offset, this.m_252907_() + offset);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

