/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.smithingtable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.generic.GenericRecipeBookComponent;
import marsh.town.brb.recipe.BRBSmithingRecipe;
import marsh.town.brb.recipe.smithing.BRBSmithingTransformRecipe;
import marsh.town.brb.recipe.smithing.BRBSmithingTrimRecipe;
import marsh.town.brb.smithingtable.SmithingGhostRecipe;
import marsh.town.brb.smithingtable.SmithingRecipeBookPage;
import marsh.town.brb.smithingtable.SmithingRecipeCollection;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.ClientInventoryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;

public class SmithingRecipeBookComponent
extends GenericRecipeBookComponent<SmithingMenu, SmithingRecipeCollection, BRBSmithingRecipe> {
    private static final MutableComponent ONLY_CRAFTABLES_TOOLTIP = Component.m_237115_((String)"brb.gui.smithable");

    public void init(int width, int height, Minecraft minecraft, boolean widthNarrow, SmithingMenu menu, Consumer<ItemStack> onGhostRecipeUpdate, RegistryAccess registryAccess, RecipeManager recipeManager) {
        super.init(width, height, minecraft, widthNarrow, menu, onGhostRecipeUpdate, registryAccess);
        this.recipeManager = recipeManager;
        this.ghostRecipe = new SmithingGhostRecipe(onGhostRecipeUpdate, registryAccess);
        this.ghostRecipe.setDefaultRenderingPredicate((SmithingMenu)this.menu);
        this.recipesPage = new SmithingRecipeBookPage(registryAccess, () -> BRBBookSettings.isFiltering(this.getRecipeBookType()));
        this.initVisuals();
    }

    @Override
    public Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    @Override
    public BRBHelper.Book getRecipeBookType() {
        return BetterRecipeBook.SMITHING;
    }

    @Override
    public void handlePlaceRecipe() {
        BRBSmithingRecipe result = (BRBSmithingRecipe)this.recipesPage.getCurrentClickedRecipe();
        SmithingRecipeCollection recipeCollection = (SmithingRecipeCollection)this.recipesPage.getLastClickedRecipeCollection();
        if (result == null || recipeCollection == null) {
            return;
        }
        this.ghostRecipe.clear();
        if (!result.hasMaterials((NonNullList<Slot>)((SmithingMenu)this.menu).f_38839_, this.registryAccess)) {
            this.setupGhostRecipe(result, (List<Slot>)((SmithingMenu)this.menu).f_38839_);
            return;
        }
        int slotIndex = 0;
        boolean placedBase = false;
        for (Slot slot : ((SmithingMenu)this.menu).f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            if (result.getTemplate().test(itemStack)) {
                assert (Minecraft.m_91087_().f_91072_ != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, ((SmithingMenu)this.menu).m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, 0, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            } else if (!placedBase && ArmorTrim.m_266285_((RegistryAccess)this.registryAccess, (ItemStack)itemStack).isEmpty() && result.getBase().m_41720_().equals(itemStack.m_41720_())) {
                assert (Minecraft.m_91087_().f_91072_ != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, ((SmithingMenu)this.menu).m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, 1, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                placedBase = true;
            } else if (result.getAddition().test(itemStack)) {
                assert (Minecraft.m_91087_().f_91072_ != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, ((SmithingMenu)this.menu).m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                Minecraft.m_91087_().f_91072_.m_171799_(((SmithingMenu)this.menu).f_38840_, 2, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            }
            ++slotIndex;
        }
        this.updateCollections(false);
    }

    public void setupGhostRecipe(BRBSmithingRecipe result, List<Slot> list) {
        this.ghostRecipe.setRecipe(result);
        this.ghostRecipe.addIngredient(2, result.getAddition(), 44, 48);
        this.ghostRecipe.addIngredient(0, result.getTemplate(), 8, 48);
        this.ghostRecipe.addIngredient(1, Ingredient.m_43927_((ItemStack[])new ItemStack[]{result.getBase()}), 26, 48);
    }

    public boolean isShowingGhostRecipe() {
        return this.ghostRecipe != null && this.ghostRecipe.size() > 0;
    }

    @Override
    protected List<SmithingRecipeCollection> getCollectionsForCategory() {
        List recipes = this.recipeManager.m_44013_(RecipeType.f_44113_);
        ArrayList<SmithingRecipeCollection> results = new ArrayList<SmithingRecipeCollection>();
        BRBBookCategories.Category category = this.selectedTab.getCategory();
        for (SmithingRecipe recipe : recipes) {
            if (category == BetterRecipeBook.SMITHING_SEARCH) {
                if (recipe instanceof SmithingTransformRecipe) {
                    results.add(new SmithingRecipeCollection(List.of(BRBSmithingTransformRecipe.from((SmithingTransformRecipe)recipe, this.registryAccess)), (SmithingMenu)this.menu, this.registryAccess));
                    continue;
                }
                if (!(recipe instanceof SmithingTrimRecipe)) continue;
                results.add(new SmithingRecipeCollection((List<? extends BRBSmithingRecipe>)BRBSmithingTrimRecipe.from((SmithingTrimRecipe)recipe), (SmithingMenu)this.menu, this.registryAccess));
                continue;
            }
            if (category == BetterRecipeBook.SMITHING_TRANSFORM) {
                if (!(recipe instanceof SmithingTransformRecipe)) continue;
                results.add(new SmithingRecipeCollection(List.of(BRBSmithingTransformRecipe.from((SmithingTransformRecipe)recipe, this.registryAccess)), (SmithingMenu)this.menu, this.registryAccess));
                continue;
            }
            if (!(recipe instanceof SmithingTrimRecipe)) continue;
            results.add(new SmithingRecipeCollection((List<? extends BRBSmithingRecipe>)BRBSmithingTrimRecipe.from((SmithingTrimRecipe)recipe), (SmithingMenu)this.menu, this.registryAccess));
        }
        return results;
    }
}

