/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.util;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientInventoryUtil {
    public static void storeItem(int fromSlot, Predicate<Integer> indexCheck) {
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        Minecraft minecraft = Minecraft.m_91087_();
        AbstractContainerMenu menu = minecraft.f_91074_.f_36096_;
        if (menu == null) {
            return;
        }
        if (fromSlot >= 0) {
            if (((Slot)menu.f_38839_.get(fromSlot)).m_7993_().m_41619_()) {
                return;
            }
            if (!menu.m_142621_().m_41619_()) {
                ClientInventoryUtil.storeItem(-1, indexCheck);
            }
            gameMode.m_171799_(menu.f_38840_, fromSlot, 0, ClickType.PICKUP, (Player)minecraft.f_91074_);
        } else if (menu.m_142621_().m_41619_()) {
            return;
        }
        ArrayList slots = new ArrayList(menu.f_38839_);
        slots.sort((a, b) -> Boolean.compare(a.m_7993_().m_41619_(), b.m_7993_().m_41619_()));
        int count = menu.m_142621_().m_41613_();
        for (Slot slot : slots) {
            int slotCount;
            if (count <= 0) break;
            if (!indexCheck.test(slot.f_40219_) || !ItemStack.m_150942_((ItemStack)menu.m_142621_(), (ItemStack)slot.m_7993_()) && !slot.m_7993_().m_41619_() || (slotCount = slot.m_7993_().m_41613_()) >= slot.m_6641_()) continue;
            count -= Math.max(0, slot.m_6641_() - slotCount);
            gameMode.m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)minecraft.f_91074_);
        }
        if (count > 0) {
            ClientInventoryUtil.dropItem(-1, true, false);
        }
    }

    public static void dropItem(int slot, boolean wholeStack, boolean force) {
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        Minecraft minecraft = Minecraft.m_91087_();
        AbstractContainerMenu menu = minecraft.f_91074_.f_36096_;
        if (menu == null) {
            return;
        }
        ClickType type = ClickType.THROW;
        if (slot < 0) {
            slot = -999;
            type = ClickType.PICKUP;
            if (!force && menu.m_142621_().m_41619_()) {
                return;
            }
        } else if (!force && ((Slot)menu.f_38839_.get(slot)).m_7993_().m_41619_()) {
            return;
        }
        gameMode.m_171799_(menu.f_38840_, slot, wholeStack ? 0 : 1, type, (Player)minecraft.f_91074_);
    }
}

