/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.block.hopper.world_edit_compat;

import com.abdelaziz.canary.common.compat.WorldEditCompat;
import com.abdelaziz.canary.common.hopper.UpdateReceiver;
import com.abdelaziz.canary.common.util.constants.DirectionConstants;
import com.abdelaziz.canary.common.world.WorldHelper;
import com.abdelaziz.canary.common.world.blockentity.BlockEntityGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin {
    @Shadow
    public abstract Level m_62953_();

    @Inject(method={"setBlockState"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onPlace(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", shift=At.Shift.BEFORE)})
    private void updateHoppersIfWorldEditPresent(BlockPos pos, BlockState state, boolean moved, CallbackInfoReturnable<BlockState> cir) {
        if (WorldEditCompat.WORLD_EDIT_PRESENT && (state.m_60734_() instanceof WorldlyContainerHolder || state.m_155947_())) {
            LevelChunkMixin.updateHopperCachesOnNewInventoryAdded((LevelChunk)this, pos, this.m_62953_());
        }
    }

    private static void updateHopperCachesOnNewInventoryAdded(LevelChunk worldChunk, BlockPos pos, Level world) {
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction offsetDirection : DirectionConstants.ALL) {
            BlockEntity neighborBlockEntity;
            neighborPos.m_122159_((Vec3i)pos, offsetDirection);
            BlockEntity blockEntity = neighborBlockEntity = WorldHelper.arePosWithinSameChunk(pos, (BlockPos)neighborPos) ? worldChunk.m_5685_((BlockPos)neighborPos, LevelChunk.EntityCreationType.CHECK) : ((BlockEntityGetter)world).getLoadedExistingBlockEntity((BlockPos)neighborPos);
            if (!(neighborBlockEntity instanceof UpdateReceiver)) continue;
            UpdateReceiver updateReceiver = (UpdateReceiver)neighborBlockEntity;
            updateReceiver.invalidateCacheOnNeighborUpdate(offsetDirection.m_122424_());
        }
    }
}

