/*
 * Decompiled with CFR 0.152.
 */
package net.yeswoman.capycraft.entity;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.yeswoman.capycraft.entity.ModEntity;
import net.yeswoman.capycraft.item.ModItems;
import net.yeswoman.capycraft.sound.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Capybara
extends TamableAnimal
implements InventoryCarrier,
GeoEntity,
VariantHolder<Variants> {
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Capybara.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Capybara.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private CapyAvoidEntityGoal<Player> avoidPlayersGoal;
    private static final RawAnimation LAY_ANIM = RawAnimation.begin().then("animation.capybara.laying", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().then("animation.capybara.idle", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().then("animation.capybara.moving", Animation.LoopType.LOOP);

    public Capybara(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new CapyAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
        }
    }

    public SimpleContainer m_35311_() {
        return null;
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("isSitting", this.isSitting());
        pCompound.m_128405_("variant", this.getVariant().ordinal());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setSitting(pCompound.m_128471_("isSitting"));
        if (pCompound.m_128441_("variant")) {
            this.f_19804_.m_135381_(DATA_VARIANT, (Object)pCompound.m_128451_("variant"));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CAPYBARA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.CAPYBARA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CAPYBARA_DEATH.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ORANGE.get(), Items.f_42575_, Items.f_41864_, Items.f_42410_, Items.f_42404_}), true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21346_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AmbientCreature.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    public void m_6703_(@Nullable LivingEntity pLivingEntity) {
        super.m_6703_(pLivingEntity);
        this.setSitting(false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Controller", 3, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(WALK_ANIM);
            }
            if (this.isSitting()) {
                state.getController().setAnimation(LAY_ANIM);
            }
            if (!this.isSitting() && !state.isMoving()) {
                state.getController().setAnimation(IDLE_ANIM);
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob pOtherParent) {
        Capybara capybara = (Capybara)((EntityType)ModEntity.CAPYBARA.get()).m_20615_((Level)serverLevel);
        if (this.m_21824_()) {
            assert (capybara != null);
            capybara.m_21816_(this.m_21805_());
            capybara.m_7105_(true);
        }
        if (capybara != null && pOtherParent instanceof Capybara) {
            Capybara capybara1 = (Capybara)pOtherParent;
            if (this.f_19796_.m_188499_()) {
                capybara.setVariant(this.getVariant());
            } else {
                capybara.setVariant(capybara1.getVariant());
            }
        }
        return capybara;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return this.m_6162_() ? 0.5f : 0.9f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_((Item)ModItems.ORANGE.get());
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        InteractionResult interactionresult1;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            return !itemstack.m_150930_(Items.f_42404_) || !itemstack.m_150930_(Items.f_42410_) || !itemstack.m_150930_(Items.f_42575_) || !itemstack.m_150930_(Items.f_41864_) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                if (itemstack.m_150930_(Items.f_42404_) || itemstack.m_150930_(Items.f_42410_) || itemstack.m_150930_(Items.f_42575_) || itemstack.m_150930_(Items.f_41864_) && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(Objects.requireNonNull(itemstack.getFoodProperties((LivingEntity)this)).m_38744_());
                    this.m_142075_(pPlayer, pHand, itemstack);
                    return InteractionResult.CONSUME;
                }
                InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
                if (!interactionresult.m_19077_() && !this.m_21827_() || this.m_6162_()) {
                    this.setSitting(true);
                } else if (!interactionresult.m_19077_() && this.m_21827_() || this.m_6162_()) {
                    this.setSitting(false);
                }
                return interactionresult;
            }
        } else if (itemstack.m_150930_(Items.f_42404_) || itemstack.m_150930_(Items.f_42410_) || itemstack.m_150930_(Items.f_42575_) || itemstack.m_150930_(Items.f_41864_)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.setSitting(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionresult1 = super.m_6071_(pPlayer, pHand)).m_19077_()) {
            this.m_21530_();
        }
        if (!interactionresult1.m_19077_()) {
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand) : InteractionResult.PASS;
        }
        return interactionresult1;
    }

    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        Variants variant = (Variants)((Object)Util.m_214670_((Object[])Variants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @NotNull
    public Variants getVariant() {
        return Variants.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    public void setVariant(Variants variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    static class CapyAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Capybara capybara;

        public CapyAvoidEntityGoal(Capybara pCapybara, Class<T> pEntityClassToAvoid, float pMaxDist, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)pCapybara, pEntityClassToAvoid, pMaxDist, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.f_20406_::test);
            this.capybara = pCapybara;
        }

        public boolean m_8036_() {
            return !this.capybara.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.capybara.m_21824_() && super.m_8045_();
        }
    }

    public static enum Variants {
        BROWN(1),
        ALBINO(2),
        DARK_BROWN(3),
        RED(4);

        private static final Variants[] BY_ID;
        private final int id;

        private Variants(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Variants byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (Variants[])Arrays.stream(Variants.values()).sorted(Comparator.comparingInt(Variants::getId)).toArray(Variants[]::new);
        }
    }
}

