/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private AccessManager() {
    }

    public static boolean hasAccess(CommandSourceStack context, UUID uuid) {
        ServerPlayer serverPlayer;
        if (context == null || uuid == null) {
            return false;
        }
        try {
            serverPlayer = context.m_81375_();
        }
        catch (CommandSyntaxException serverPlayerException) {
            Entity entity;
            try {
                entity = context.m_81374_();
            }
            catch (CommandSyntaxException entityException) {
                log.warn("Skipping access check for EasyNPC with UUID {} due to missing player and entity!", (Object)uuid);
                return true;
            }
            log.error("The entity {} tried to access EasyNPC with UUID {}!", (Object)entity, (Object)uuid);
            return false;
        }
        return AccessManager.hasAccess(serverPlayer, uuid);
    }

    public static boolean hasAccess(ServerPlayer serverPlayer, UUID uuid) {
        return AccessManager.getEasyNPCEntityByUUID(uuid, serverPlayer) != null;
    }

    public static EasyNPC<?> getEasyNPCEntityByUUID(UUID uuid, ServerPlayer serverPlayer) {
        if (serverPlayer == null || uuid == null) {
            return null;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("[{}:{}] Unable to get valid entity!", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        if (!serverPlayer.m_7500_() && !easyNPC.getEasyNPCOwnerData().isOwner(serverPlayer)) {
            log.error("[{}:{}] Player has no access!", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        return easyNPC;
    }
}

