/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseEntityModel;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Rotations;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class StandardHorseModel<T extends Entity>
extends BaseEntityModel<T>
implements HeadedModel {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, Rotations> modelPartRotationMap = new EnumMap<ModelPartType, Rotations>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart tail;
    protected final ModelPart headParts;
    protected final ModelPart saddle;
    protected final ModelPart leftSaddleMouth;
    protected final ModelPart rightSaddleMouth;
    protected final ModelPart leftSaddleLine;
    protected final ModelPart rightSaddleLine;
    protected final ModelPart headSaddle;
    protected final ModelPart mouthSaddleWrap;

    public StandardHorseModel(ModelPart modelPart) {
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.headParts = this.defineModelPart(ModelPartType.HEAD_PARTS, modelPart, "head_parts");
        this.head = this.defineModelPart(ModelPartType.HEAD, this.headParts, "head");
        this.rightFrontLeg = this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.leftFrontLeg = this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.rightHindLeg = this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.leftHindLeg = this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.tail = this.defineModelPart(ModelPartType.TAIL, this.body, "tail");
        this.saddle = this.body.m_171324_("saddle");
        this.rightSaddleMouth = this.headParts.m_171324_("right_saddle_mouth");
        this.leftSaddleMouth = this.headParts.m_171324_("left_saddle_mouth");
        this.rightSaddleLine = this.headParts.m_171324_("right_saddle_line");
        this.leftSaddleLine = this.headParts.m_171324_("left_saddle_line");
        this.headSaddle = this.headParts.m_171324_("head_saddle");
        this.mouthSaddleWrap = this.headParts.m_171324_("mouth_saddle_wrap");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD_PARTS, this.headParts);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.TAIL, this.tail);
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        boolean isSaddled;
        VariantData<?> variantData = easyNPC.getEasyNPCVariantData();
        this.saddle.f_104207_ = isSaddled = variantData.hasVariantSaddled();
        this.rightSaddleMouth.f_104207_ = isSaddled;
        this.leftSaddleMouth.f_104207_ = isSaddled;
        this.rightSaddleLine.f_104207_ = isSaddled;
        this.leftSaddleLine.f_104207_ = isSaddled;
        this.headSaddle.f_104207_ = isSaddled;
        this.mouthSaddleWrap.f_104207_ = isSaddled;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.headParts, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelFrontLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean animateModelHindLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    public Iterable<ModelPart> headParts() {
        return List.of(this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.headParts().forEach(headPart -> headPart.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha));
        this.bodyParts().forEach(bodyPart -> bodyPart.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha));
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public boolean isHumanoidModel() {
        return false;
    }
}

