/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmHeadModel;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class StandardIllagerModel<T extends Mob>
extends BaseHierarchicalArmHeadModel<T> {
    private final ModelPart arms;

    public StandardIllagerModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart hat = this.head.m_171324_("hat");
        hat.f_104207_ = false;
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
    }

    @Override
    public void resetModelParts() {
        super.resetModelParts();
        this.resetModelPart(ModelPartType.ARMS, this.arms);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isCrossedArms;
        if (!(entity instanceof EasyNPC)) {
            return;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        ModelData modelData = easyNPC.getEasyNPCModelData();
        VariantData variantData = easyNPC.getEasyNPCVariantData();
        this.arms.f_104207_ = isCrossedArms = (modelData.getModelArmPose() == ModelArmPose.CROSSED || variantData.hasVariantCrossedArms()) && !AttackHandler.isHoldingWeapon(entity);
        this.leftArm.f_104207_ = !isCrossedArms;
        this.rightArm.f_104207_ = !isCrossedArms;
        this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.f_104203_ = 0.5f;
        this.body.f_104201_ = 3.2f;
        this.head.f_104201_ = 4.2f;
        if (this.arms.f_104207_) {
            this.arms.f_104203_ += 0.4f;
            this.arms.f_104201_ = 5.2f;
        }
        if (this.leftArm.f_104207_) {
            this.leftArm.f_104203_ += 0.4f;
            this.leftArm.f_104201_ = 5.2f;
        }
        this.leftLeg.f_104201_ = 12.2f;
        this.leftLeg.f_104202_ = 4.0f;
        if (this.rightArm.f_104207_) {
            this.rightArm.f_104203_ += 0.4f;
            this.rightArm.f_104201_ = 5.2f;
        }
        this.rightLeg.f_104201_ = 12.2f;
        this.rightLeg.f_104202_ = 4.0f;
        return true;
    }
}

