/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmPoseAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class StandardSkeletonModel<T extends Mob>
extends SkeletonModel<T>
implements EasyNPCModel<T>,
HumanoidArmAnimation,
HumanoidArmPoseAnimation {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, Rotations> modelPartRotationMap = new EnumMap<ModelPartType, Rotations>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);

    public StandardSkeletonModel(ModelPart modelPart) {
        super(modelPart);
        this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.defineModelPart(ModelPartType.HAT, modelPart, "hat");
        this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm");
        this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm");
        this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.f_102808_);
        this.resetModelPart(ModelPartType.HAT, this.f_102809_);
        this.resetModelPart(ModelPartType.BODY, this.f_102810_);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.f_102811_);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.f_102812_);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.f_102813_);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.f_102814_);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.f_104203_ = headPitch * ((float)Math.PI / 180);
        headPart.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean animateModelArms(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean animateModelArmPose(T entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidArmPoseAnimation.animateHumanoidArmPose(entity, modelArmPose, this.f_102808_, this.f_102810_, this.f_102811_, this.f_102812_, this.f_102608_, ageInTicks);
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        this.f_102809_.m_104315_(this.f_102808_);
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.f_102808_, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102810_, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102812_, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102811_, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102814_, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.f_102813_, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102810_.f_104203_ = 0.5f;
        this.f_102810_.f_104201_ = 3.2f;
        this.f_102808_.f_104201_ = 4.2f;
        this.f_102812_.f_104203_ += 0.4f;
        this.f_102812_.f_104201_ = 5.2f;
        this.f_102814_.f_104201_ = 12.2f;
        this.f_102814_.f_104202_ = 4.0f;
        this.f_102811_.f_104203_ += 0.4f;
        this.f_102811_.f_104201_ = 5.2f;
        this.f_102813_.f_104201_ = 12.2f;
        this.f_102813_.f_104202_ = 4.0f;
        return true;
    }

    @Override
    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.modelPartPositionMap.put(modelPartType, customPosition);
    }

    @Override
    public void setDefaultModelPartRotation(ModelPartType modelPartType, Rotations rotations) {
        this.modelPartRotationMap.put(modelPartType, rotations);
    }

    @Override
    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    @Override
    public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.modelPartPositionMap.getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    @Override
    public Rotations getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.modelPartRotationMap.getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    @Override
    public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.getOrDefault((Object)modelPartType, null);
    }
}

