/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final String LOG_PREFIX = "[RendererManager]";
    private static final Set<EntityType<?>> unsupportedEntityTypes = new HashSet();
    private static final Map<EntityType<?>, PathfinderMob> pathfinderMobMap = new HashMap();
    private static final Map<EntityType<?>, EntityRenderer<?>> entityRendererMap = new HashMap();
    private static final Map<EntityType<?>, LivingEntityRenderer<?, ?>> livingEntityRendererMap = new HashMap();
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private RendererManager() {
    }

    public static void setPathfinderMob(EntityType<?> entityType, PathfinderMob pathfinderMob) {
        pathfinderMobMap.put(entityType, pathfinderMob);
    }

    public static void setEntityRenderer(EntityType<?> entityType, EntityRenderer<?> entityRenderer) {
        entityRendererMap.put(entityType, entityRenderer);
    }

    public static void setLivingEntityRenderer(EntityType<?> entityType, LivingEntityRenderer<?, ?> livingEntityRenderer) {
        livingEntityRendererMap.put(entityType, livingEntityRenderer);
    }

    public static PathfinderMob getPathfinderMob(EntityType<?> entityType) {
        return pathfinderMobMap.get(entityType);
    }

    public static EntityRenderer<?> getEntityRenderer(EntityType<?> entityType) {
        return entityRendererMap.get(entityType);
    }

    public static LivingEntityRenderer<?, ?> getLivingEntityRenderer(EntityType<?> entityType) {
        return livingEntityRendererMap.get(entityType);
    }

    public static boolean isSupportedEntityType(EntityType<?> entityType) {
        return !unsupportedEntityTypes.contains(entityType);
    }

    public static boolean isUnsupportedEntityType(EntityType<?> entityType) {
        return unsupportedEntityTypes.contains(entityType);
    }

    public static boolean hasPathfinderMob(EntityType<?> entityType) {
        return pathfinderMobMap.containsKey(entityType);
    }

    public static boolean hasEntityRenderer(EntityType<?> entityType) {
        return entityRendererMap.containsKey(entityType);
    }

    public static boolean hasLivingEntityRenderer(EntityType<?> entityType) {
        return livingEntityRendererMap.containsKey(entityType);
    }

    public static PathfinderMob registerPathfinderMob(EntityType<?> entityType, Level level) {
        if (entityType == null) {
            return null;
        }
        if (pathfinderMobMap.containsKey(entityType)) {
            log.warn("{} PathfinderMob for {} already registered", (Object)LOG_PREFIX, entityType);
            return pathfinderMobMap.get(entityType);
        }
        if (unsupportedEntityTypes.contains(entityType)) {
            log.error("{} Entity type {} is unsupported!", (Object)LOG_PREFIX, entityType);
            return null;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            log.debug("{} Registering PathfinderMob {} for {}", (Object)LOG_PREFIX, (Object)pathfinderMob, entityType);
            pathfinderMob.m_21557_(true);
            pathfinderMob.m_20225_(true);
            pathfinderMob.f_19794_ = true;
            RendererManager.setPathfinderMob(entityType, pathfinderMob);
            return pathfinderMob;
        }
        log.error("{} Invalid Entity type {} is not extending PathfinderMob!", (Object)LOG_PREFIX, entityType);
        unsupportedEntityTypes.add(entityType);
        return null;
    }

    public static void registerRenderer(EntityType<?> entityType, Level level) {
        if (entityType == null) {
            return;
        }
        if (pathfinderMobMap.containsKey(entityType)) {
            log.warn("{} Renderer for {} already registered", (Object)LOG_PREFIX, entityType);
            return;
        }
        if (unsupportedEntityTypes.contains(entityType)) {
            log.error("{} Entity type {} is unsupported!", (Object)LOG_PREFIX, entityType);
            return;
        }
        PathfinderMob pathfinderMob = RendererManager.registerPathfinderMob(entityType, level);
        if (pathfinderMob == null) {
            log.error("{} PathfinderMob for {} is not available!", (Object)LOG_PREFIX, entityType);
            return;
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_((Entity)pathfinderMob);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            log.debug("{} Registering living entity renderer {} for {}", (Object)LOG_PREFIX, (Object)livingEntityRenderer, entityType);
            pathfinderMobMap.put(entityType, pathfinderMob);
            entityRendererMap.put(entityType, entityRenderer);
            livingEntityRendererMap.put(entityType, livingEntityRenderer);
        } else {
            log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
            pathfinderMobMap.put(entityType, pathfinderMob);
            entityRendererMap.put(entityType, entityRenderer);
        }
    }

    public static void copyCustomEntityData(PathfinderMob sourceEntity, Entity targetEntity) {
        if (sourceEntity == null || targetEntity == null || sourceEntity == targetEntity) {
            return;
        }
        targetEntity.f_19797_ = sourceEntity.f_19797_;
        targetEntity.m_146922_(sourceEntity.m_146908_());
        targetEntity.f_19859_ = sourceEntity.f_19859_;
        targetEntity.m_146926_(sourceEntity.m_146909_());
        targetEntity.f_19860_ = sourceEntity.f_19860_;
        targetEntity.m_5616_(sourceEntity.m_6080_());
        targetEntity.m_5618_(sourceEntity.f_20883_);
        targetEntity.m_6853_(sourceEntity.m_20096_());
        targetEntity.m_20256_(sourceEntity.m_20184_());
    }

    public static void copyCustomLivingEntityData(PathfinderMob sourceEntity, LivingEntity targetEntity) {
        if (sourceEntity == null || targetEntity == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyCustomEntityData(sourceEntity, (Entity)targetEntity);
        targetEntity.f_20886_ = sourceEntity.f_20886_;
        targetEntity.f_20884_ = sourceEntity.f_20884_;
        targetEntity.f_20921_ = sourceEntity.f_20921_;
        targetEntity.f_20920_ = sourceEntity.f_20920_;
    }
}

