/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardPlayerModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseLivingEntityModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Humanoid;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class HumanoidModelRenderer
extends BaseLivingEntityModelRenderer<Humanoid, Humanoid.Variant, StandardPlayerModel<Humanoid>> {
    protected static final Map<Humanoid.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Humanoid.Variant.class), map -> {
        map.put(Humanoid.Variant.ALEX, new ResourceLocation("textures/entity/player/wide/alex.png"));
        map.put(Humanoid.Variant.ARI, new ResourceLocation("textures/entity/player/wide/ari.png"));
        map.put(Humanoid.Variant.EFE, new ResourceLocation("textures/entity/player/wide/efe.png"));
        map.put(Humanoid.Variant.KAI, new ResourceLocation("textures/entity/player/wide/kai.png"));
        map.put(Humanoid.Variant.MAKENA, new ResourceLocation("textures/entity/player/wide/makena.png"));
        map.put(Humanoid.Variant.NOOR, new ResourceLocation("textures/entity/player/wide/noor.png"));
        map.put(Humanoid.Variant.STEVE, new ResourceLocation("textures/entity/player/wide/steve.png"));
        map.put(Humanoid.Variant.SUNNY, new ResourceLocation("textures/entity/player/wide/sunny.png"));
        map.put(Humanoid.Variant.ZURI, new ResourceLocation("textures/entity/player/wide/zuri.png"));
        map.put(Humanoid.Variant.JAYJASONBO, new ResourceLocation("easy_npc", "textures/entity/humanoid/jayjasonbo.png"));
        map.put(Humanoid.Variant.PROFESSOR_01, new ResourceLocation("easy_npc", "textures/entity/humanoid/professor_01.png"));
        map.put(Humanoid.Variant.SECURITY_01, new ResourceLocation("easy_npc", "textures/entity/humanoid/security_01.png"));
        map.put(Humanoid.Variant.KNIGHT_01, new ResourceLocation("easy_npc", "textures/entity/humanoid/knight_01.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Humanoid.Variant.STEVE);

    public <L extends RenderLayer<Humanoid, StandardPlayerModel<Humanoid>>> HumanoidModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new StandardPlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.m_115326_((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.f_171164_, ModelLayers.f_171165_, humanoidArmorLayerClass));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
    }

    @Override
    public ResourceLocation getTextureLocation(Humanoid entity) {
        return this.getEntityPlayerTexture(entity);
    }

    @Override
    public void renderDefaultPose(Humanoid entity, StandardPlayerModel<Humanoid> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-1.0, 0.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                model.m_5585_().f_104203_ = -0.7853982f;
                model.m_5585_().f_104204_ = -0.7853982f;
                model.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-35.0f));
                break;
            }
            default: {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                model.m_5585_().f_104203_ = 0.0f;
                model.m_5585_().f_104204_ = 0.0f;
                model.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

