/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SliderButton
extends AbstractSliderButton {
    public static final int DEFAULT_HEIGHT = 16;
    protected static final Component EMPTY_TEXT = Component.m_237113_((String)"");
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("minecraft", "textures/gui/slider.png");
    protected final OnChange onChange;
    protected final float maxValue;
    private final float minValue;
    private final float stepSize;
    private final float valueFraction;
    private final Type type;
    private float initValue;
    private float targetValue;
    private float roundFactor = 100.0f;

    public SliderButton(int x, int y, int width, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, 16, (Component)Component.m_237113_((String)name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, EMPTY_TEXT, initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, (Component)Component.m_237113_((String)name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, double initValue, double minValue, double maxValue, OnChange onChange) {
        this(x, y, width, height, (Component)Component.m_237113_((String)name), (float)initValue, (float)minValue, (float)maxValue, onChange, Type.DOUBLE);
    }

    public SliderButton(int x, int y, int width, int height, Component name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        super(x, y, width, height, name, (double)initValue);
        this.initValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = SliderButton.getStepSize(type);
        this.valueFraction = maxValue - minValue;
        this.f_93577_ = (this.initValue - minValue) / this.valueFraction;
        if (this.minValue == 0.0f && this.maxValue == 360.0f || this.minValue == -180.0f && this.maxValue == 180.0f) {
            this.roundFactor = 1.0f;
        }
        this.onChange = onChange;
        this.type = type;
        this.updateTargetValue();
        this.m_5695_();
    }

    private static float getMinValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> -180.0f;
            case Type.DOUBLE -> 0.0f;
            case Type.SCALE -> 0.1f;
            case Type.POSITION -> -24.0f;
            default -> -100.0f;
        };
    }

    private static float getMaxValue(Type type) {
        return switch (type) {
            case Type.DEGREE -> 180.0f;
            case Type.DOUBLE -> 1024.0f;
            case Type.SCALE -> 10.0f;
            case Type.POSITION -> 24.0f;
            default -> 100.0f;
        };
    }

    private static float getStepSize(Type type) {
        return switch (type) {
            case Type.DEGREE -> 0.5f;
            case Type.DOUBLE -> 1.0f;
            case Type.SCALE -> 0.1f;
            case Type.POSITION -> 0.1f;
            default -> 1.0f;
        };
    }

    public void setDefaultValue(double value) {
        this.setDefaultValue((float)Math.round(value * (double)this.roundFactor) / this.roundFactor);
    }

    public void setDefaultValue(float value) {
        this.initValue = value;
        this.f_93577_ = (this.initValue - this.minValue) / this.valueFraction;
        this.m_5697_();
        this.m_5695_();
    }

    public void reset() {
        this.setDefaultValue(0.0f);
    }

    public void resetToDefault() {
        this.setDefaultValue(this.initValue);
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    private void setTargetValue(double value) {
        this.f_93577_ = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        this.m_5697_();
        this.m_5695_();
    }

    public double getTargetDoubleValue() {
        return this.targetValue;
    }

    private void updateTargetValue() {
        this.targetValue = (float)Math.round(((double)this.minValue + (double)this.valueFraction * this.f_93577_) * (double)this.roundFactor) / this.roundFactor;
    }

    private double getStepSize() {
        return this.stepSize / this.valueFraction;
    }

    protected void m_5695_() {
        switch (this.type) {
            case DEGREE: {
                this.m_93666_((Component)Component.m_237113_((String)(this.targetValue + "\u00b0")));
                break;
            }
            default: {
                this.m_93666_((Component)Component.m_237113_((String)("" + this.targetValue)));
            }
        }
    }

    protected void m_5697_() {
        this.updateTargetValue();
        this.onChange.onChange(this);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics) {
        int i = this.m_198029_() ? 60 : 40;
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, i, 4, this.f_93619_);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)) + 4, this.m_252907_(), 196, i, 4, this.f_93619_);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_() + this.f_93619_ - 4, 0, i + 20 - 4, 4, 4);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)) + 4, this.m_252907_() + this.f_93619_ - 4, 196, i + 20 - 4, 4, 4);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 || keyCode == 262) {
            float step = keyCode == 263 ? -1.0f : 1.0f;
            double incrementalSteps = (double)step * this.getStepSize();
            this.setTargetValue(this.f_93577_ + incrementalSteps);
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double distance) {
        if (this.m_198029_()) {
            double incrementalSteps = distance * this.getStepSize();
            this.setTargetValue(this.f_93577_ + incrementalSteps);
        }
        return true;
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int i = this.m_198029_() ? 20 : 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_(), this.m_252907_(), 0, i, this.f_93618_ / 2, this.f_93619_);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), 200 - this.f_93618_ / 2, i, this.f_93618_ / 2, this.f_93619_);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_(), this.m_252907_() + this.f_93619_ - 4, 0, i + 20 - 4, this.f_93618_ / 2, 4);
        guiGraphics.m_280218_(SLIDER_LOCATION, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + this.f_93619_ - 4, 200 - this.f_93618_ / 2, i + 20 - 4, this.f_93618_ / 2, 4);
        this.renderBg(guiGraphics);
        int fgColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        guiGraphics.m_280653_(font, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, fgColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    public static enum Type {
        DOUBLE,
        DEGREE,
        POSITION,
        SCALE,
        UNKNOWN;

    }

    public static interface OnChange {
        public void onChange(SliderButton var1);
    }
}

