/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.menu.configuration.dialog.AdvancedDialogConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedDialogConfigurationScreen
extends DialogConfigurationScreen<AdvancedDialogConfigurationMenu> {
    Button newDialogButton;
    DialogList dialogList;

    public AdvancedDialogConfigurationScreen(AdvancedDialogConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedDialogButton.f_93623_ = false;
        this.dialogList = new DialogList();
        this.m_7787_((GuiEventListener)this.dialogList);
        this.newDialogButton = (Button)this.m_142416_((GuiEventListener)new AddButton(this.contentLeftPos, this.contentTopPos + 168, 200, "dialog.add", onPress -> ServerNetworkMessageHandler.openDialogEditor(this.uuid, ConfigurationType.ADVANCED_DIALOG)));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        guiGraphics.m_280509_(this.f_97735_ + 5, this.f_97736_ + 40, this.f_97735_ + 314, this.f_97736_ + 230, -1118482);
        guiGraphics.m_280509_(this.f_97735_ + 109, this.f_97736_ + 40, this.f_97735_ + 110, this.f_97736_ + 210, -4473925);
        guiGraphics.m_280509_(this.f_97735_ + 198, this.f_97736_ + 40, this.f_97735_ + 199, this.f_97736_ + 210, -4473925);
        this.dialogList.m_88315_(guiGraphics, x, y, partialTicks);
        guiGraphics.m_280509_(this.f_97735_ + 5, this.f_97736_ + 40, this.f_97735_ + 314, this.f_97736_ + 59, -5592406);
        guiGraphics.m_280509_(this.f_97735_ + 5, this.f_97736_ + 210, this.f_97735_ + 314, this.f_97736_ + 230, -5592406);
        int headerLeft = this.f_97735_ + 10;
        Text.drawConfigString(guiGraphics, this.f_96547_, "label_id", headerLeft, this.f_97736_ + 45, 0);
        Text.drawString(guiGraphics, this.f_96547_, "Name", headerLeft + 103, this.f_97736_ + 45, 0);
        Text.drawString(guiGraphics, this.f_96547_, "Text", headerLeft + 191, this.f_97736_ + 45, 0);
        guiGraphics.m_280509_(this.f_97735_ + 109, this.f_97736_ + 40, this.f_97735_ + 110, this.f_97736_ + 59, -10066330);
        guiGraphics.m_280509_(this.f_97735_ + 198, this.f_97736_ + 40, this.f_97735_ + 199, this.f_97736_ + 59, -10066330);
        this.newDialogButton.m_88315_(guiGraphics, x, y, partialTicks);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    @OnlyIn(value=Dist.CLIENT)
    class DialogList
    extends ObjectSelectionList<Entry> {
        DialogList() {
            super(AdvancedDialogConfigurationScreen.this.f_96541_, AdvancedDialogConfigurationScreen.this.f_96543_ + 50, AdvancedDialogConfigurationScreen.this.f_96544_ - 60, AdvancedDialogConfigurationScreen.this.f_97736_ + 56, AdvancedDialogConfigurationScreen.this.f_97736_ + 211, 19);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            for (DialogDataEntry dialogData : AdvancedDialogConfigurationScreen.this.dialogDataSet.getDialogsByLabel()) {
                if (dialogData == null || dialogData.getId() == null) continue;
                this.m_7085_((AbstractSelectionList.Entry)new Entry(dialogData));
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_88315_(guiGraphics, x, y, partialTicks);
            }
        }

        protected void m_240140_(GuiGraphics guiGraphics, int right, int top, int width, int height, int color) {
        }

        @OnlyIn(value=Dist.CLIENT)
        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final DialogDataEntry dialogData;
            final EditButton editButton;
            final CopyButton copyLabelButton;
            final TextEditButton textEditButton;
            final String defaultDialogLabel;

            public Entry(DialogDataEntry dialogData) {
                this.dialogData = dialogData;
                this.editButton = new EditButton(0, 0, onPress -> ServerNetworkMessageHandler.openDialogEditor(AdvancedDialogConfigurationScreen.this.uuid, this.dialogData.getId(), ConfigurationType.ADVANCED_DIALOG));
                this.copyLabelButton = new CopyButton(0, 0, onPress -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91068_.m_90911_(dialogData.getLabel());
                });
                this.textEditButton = new TextEditButton(0, 0, onPress -> ServerNetworkMessageHandler.openDialogTextEditor(AdvancedDialogConfigurationScreen.this.uuid, this.dialogData.getId(), ConfigurationType.ADVANCED_DIALOG));
                this.defaultDialogLabel = AdvancedDialogConfigurationScreen.this.dialogDataSet.getDefaultDialogLabel();
            }

            public Component m_142172_() {
                return Component.m_237115_((String)this.dialogData.getName());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                super.m_6375_(mouseX, mouseY, button);
                this.copyLabelButton.m_6375_(mouseX, mouseY, button);
                this.editButton.m_6375_(mouseX, mouseY, button);
                this.textEditButton.m_6375_(mouseX, mouseY, button);
                return button == 0;
            }

            public void m_6311_(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
                int leftPos = left - 75;
                this.editButton.m_252865_(leftPos + 75);
                this.editButton.m_253211_(top);
                this.editButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.editButton.m_274382_()) {
                    guiGraphics.m_280557_(AdvancedDialogConfigurationScreen.this.f_96547_, (Component)Component.m_237110_((String)"text.easy_npc.config.dialog.edit_dialog", (Object[])new Object[]{this.dialogData.getName()}), mouseX, mouseY);
                }
                this.copyLabelButton.m_252865_(this.editButton.m_252754_() + this.editButton.m_5711_());
                this.copyLabelButton.m_253211_(top);
                this.copyLabelButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.copyLabelButton.m_274382_()) {
                    guiGraphics.m_280557_(AdvancedDialogConfigurationScreen.this.f_96547_, (Component)Component.m_237110_((String)"text.easy_npc.config.dialog.copy_dialog_label", (Object[])new Object[]{this.dialogData.getLabel()}), mouseX, mouseY);
                }
                this.textEditButton.m_252865_(leftPos + 200);
                this.textEditButton.m_253211_(top);
                this.textEditButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.textEditButton.m_274382_()) {
                    guiGraphics.m_280557_(AdvancedDialogConfigurationScreen.this.f_96547_, (Component)Component.m_237110_((String)"text.easy_npc.config.dialog.edit_dialog_text", (Object[])new Object[]{this.dialogData.getText()}), mouseX, mouseY);
                }
                float dialogDataScale = 0.75f;
                int dialogDataTopPos = Math.round((float)(top + 5) / dialogDataScale);
                int fontColor = this.dialogData.getLabel().equals(this.defaultDialogLabel) ? 43520 : 0;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(dialogDataScale, dialogDataScale, dialogDataScale);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getLabel(16), Math.round((float)(leftPos + 7) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getName(21), Math.round((float)(leftPos + 112) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getText(25), Math.round((float)(leftPos + 220) / dialogDataScale), dialogDataTopPos, fontColor);
                guiGraphics.m_280168_().m_85849_();
                guiGraphics.m_280509_(AdvancedDialogConfigurationScreen.this.f_97735_ + 5, top + 17, AdvancedDialogConfigurationScreen.this.f_97735_ + 314, top + 18, -5592406);
            }
        }
    }
}

