/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.configuration.dialog.YesNoDialogConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YesNoDialogConfigurationScreen
extends DialogConfigurationScreen<YesNoDialogConfigurationMenu> {
    private static final String YES_BUTTON_LABEL = "yes_button";
    private static final String NO_BUTTON_LABEL = "no_button";
    private final DialogDataEntry questionDialogData = this.dialogDataSet.getDialog("question");
    private final DialogDataEntry yesDialogData = this.dialogDataSet.getDialog("yes_answer");
    private final DialogDataEntry noDialogData = this.dialogDataSet.getDialog("no_answer");
    protected EditBox mainDialogBox;
    protected Button yesDialogButton;
    protected Button noDialogButton;
    protected EditBox yesDialogBox;
    protected EditBox noDialogBox;
    protected Button saveButton = null;
    protected Button cancelButton = null;
    boolean showSaveNotificationForButtons = false;
    private String questionDialogValue = "";
    private String yesDialogValue = "";
    private String noDialogValue = "";

    public YesNoDialogConfigurationScreen(YesNoDialogConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.yesNoDialogButton.f_93623_ = false;
        DialogButtonData yesButtonData = this.questionDialogData == null ? null : this.questionDialogData.getButton(YES_BUTTON_LABEL);
        DialogButtonData noButtonData = this.questionDialogData == null ? null : this.questionDialogData.getButton(NO_BUTTON_LABEL);
        String string = this.questionDialogValue = this.questionDialogData == null ? "" : this.questionDialogData.getText();
        if (this.questionDialogValue.isEmpty() && this.dialogDataSet.getDefaultDialog() != null && this.dialogDataSet.getType() == DialogType.BASIC) {
            this.questionDialogValue = this.dialogDataSet.getDefaultDialog().getText();
        }
        if (this.questionDialogData == null) {
            this.showSaveNotificationForButtons = true;
        }
        this.mainDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.f_97736_ + 50, 300);
        this.mainDialogBox.m_94199_(512);
        this.mainDialogBox.m_94144_(this.questionDialogValue);
        this.m_142416_((GuiEventListener)this.mainDialogBox);
        MutableComponent yesButtonText = Component.m_237113_((String)TextUtils.limitString(yesButtonData == null ? "Yes Button" : yesButtonData.getName(), 18));
        this.yesDialogButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.f_97736_ + 85, 145, (Component)yesButtonText, onPress -> {
            UUID yesButtonId;
            UUID uUID = yesButtonId = yesButtonData == null ? null : yesButtonData.getId();
            if (this.questionDialogData != null) {
                if (yesButtonId != null) {
                    ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.questionDialogData.getId(), yesButtonId, ConfigurationType.YES_NO_DIALOG);
                } else {
                    ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.questionDialogData.getId(), ConfigurationType.YES_NO_DIALOG);
                }
            }
        }));
        MutableComponent noButtonText = Component.m_237113_((String)TextUtils.limitString(noButtonData == null ? "No Button" : noButtonData.getName(), 18));
        this.noDialogButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 155, this.f_97736_ + 85, 145, (Component)noButtonText, onPress -> {
            UUID noButtonId;
            UUID uUID = noButtonId = noButtonData == null ? null : noButtonData.getId();
            if (this.questionDialogData != null) {
                if (noButtonId != null) {
                    ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.questionDialogData.getId(), noButtonId, ConfigurationType.YES_NO_DIALOG);
                } else {
                    ServerNetworkMessageHandler.openDialogButtonEditor(this.uuid, this.questionDialogData.getId(), ConfigurationType.YES_NO_DIALOG);
                }
            }
        }));
        this.yesDialogValue = this.yesDialogData == null ? "" : this.yesDialogData.getText();
        this.yesDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.f_97736_ + 130, 300);
        this.yesDialogBox.m_94199_(255);
        this.yesDialogBox.m_94144_(this.yesDialogValue);
        this.m_142416_((GuiEventListener)this.yesDialogBox);
        this.noDialogValue = this.noDialogData == null ? "" : this.noDialogData.getText();
        this.noDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.f_97736_ + 170, 300);
        this.noDialogBox.m_94199_(255);
        this.noDialogBox.m_94144_(this.noDialogValue);
        this.m_142416_((GuiEventListener)this.noDialogBox);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.contentLeftPos + 26, this.bottomPos - 40, "save", onPress -> {
            DialogDataSet dialogDataSet = DialogUtils.getYesNoDialog(this.mainDialogBox.m_94155_(), "Yes", "No", this.yesDialogBox.m_94155_(), this.noDialogBox.m_94155_());
            if (this.questionDialogData != null) {
                Set<DialogButtonData> dialogButtonDataSet = this.questionDialogData.getButtons();
                if (!this.questionDialogData.hasButton(YES_BUTTON_LABEL)) {
                    dialogButtonDataSet.add(dialogDataSet.getDialog("question").getButton(YES_BUTTON_LABEL));
                }
                if (!this.questionDialogData.hasButton(NO_BUTTON_LABEL)) {
                    dialogButtonDataSet.add(dialogDataSet.getDialog("question").getButton(NO_BUTTON_LABEL));
                }
                dialogDataSet.getDialog("question").setButtons(dialogButtonDataSet);
            }
            this.questionDialogValue = this.mainDialogBox.m_94155_();
            this.yesDialogValue = this.yesDialogBox.m_94155_();
            this.noDialogValue = this.noDialogBox.m_94155_();
            ServerNetworkMessageHandler.saveDialog(this.uuid, dialogDataSet);
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.rightPos - 130, this.bottomPos - 40, "cancel", onPress -> this.showMainScreen()));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        Text.drawConfigString(guiGraphics, this.f_96547_, "question", this.contentLeftPos, this.f_97736_ + 40);
        Text.drawConfigString(guiGraphics, this.f_96547_, "edit_yes_button", this.contentLeftPos, this.f_97736_ + 75);
        Text.drawConfigString(guiGraphics, this.f_96547_, "edit_no_button", this.contentLeftPos + 155, this.f_97736_ + 75);
        Text.drawConfigString(guiGraphics, this.f_96547_, "yes_answer", this.contentLeftPos, this.yesDialogBox.m_252907_() - 12);
        Text.drawConfigString(guiGraphics, this.f_96547_, "no_answer", this.contentLeftPos, this.noDialogBox.m_252907_() - 12);
        if (this.showSaveNotificationForButtons) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "save_before_edit_buttons", this.contentLeftPos + 65, this.f_97736_ + 105, 0xFF5555);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.mainDialogBox.m_94155_().equals(this.questionDialogValue) || !this.yesDialogBox.m_94155_().equals(this.yesDialogValue) || !this.noDialogBox.m_94155_().equals(this.noDialogValue);
        }
        if (this.yesDialogButton != null && this.dialogDataSet != null) {
            boolean bl = this.yesDialogButton.f_93623_ = this.dialogDataSet.hasDialog("question") && this.dialogDataSet.getDialog("question").hasButton(YES_BUTTON_LABEL);
        }
        if (this.noDialogButton != null && this.dialogDataSet != null) {
            this.noDialogButton.f_93623_ = this.dialogDataSet.hasDialog("question") && this.dialogDataSet.getDialog("question").hasButton(NO_BUTTON_LABEL);
        }
    }
}

