/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.equipment;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentConfigurationScreen
extends ConfigurationScreen<EquipmentConfigurationMenu> {
    protected final ModelData<?> modelData;
    protected Button defaultEquipmentButton;

    public EquipmentConfigurationScreen(EquipmentConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.modelData = this.easyNPC.getEasyNPCModelData();
    }

    private void createVisibleEquipmentSlotCheckbox(int left, int top, EquipmentSlot equipmentSlot) {
        boolean modelEquipmentVisibility = this.modelData.isModelEquipmentVisible(equipmentSlot);
        this.m_142416_((GuiEventListener)new Checkbox(left, top, "", modelEquipmentVisibility, checkbox -> ServerNetworkMessageHandler.modelVisibilityChange(this.uuid, equipmentSlot, checkbox.selected())));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        this.defaultEquipmentButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "equipment", button -> {}));
        this.defaultEquipmentButton.f_93623_ = false;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
        if (this.modelData.canUseArmor()) {
            int equipmentSlotLeft = this.contentLeftPos + 75;
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 2, EquipmentSlot.HEAD);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 20, EquipmentSlot.CHEST);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 38, EquipmentSlot.LEGS);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, this.contentTopPos + 55, EquipmentSlot.FEET);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderScaledEntityAvatar(this.contentLeftPos + 138, this.contentTopPos + 82, 35, (float)(this.contentLeftPos + 140) - this.xMouse, (float)(this.contentTopPos + 30) - this.yMouse, this.easyNPC.getLivingEntity());
        this.m_280072_(guiGraphics, x, y);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.modelData == null || this.modelData.canUseArmor()) {
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 90, this.contentTopPos, 7, 7, 18, 72);
        }
        if (this.modelData == null || this.modelData.canUseMainHand()) {
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 90, this.contentTopPos + 75, 7, 7, 18, 18);
        }
        if (this.modelData == null || this.modelData.canUseOffHand()) {
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 170, this.contentTopPos + 75, 7, 7, 18, 18);
        }
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 58, this.contentTopPos + 105, 7, 83, 162, 54);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 58, this.contentTopPos + 165, 7, 141, 162, 18);
        guiGraphics.m_280509_(this.contentLeftPos + 109, this.contentTopPos - 8, this.contentLeftPos + 169, this.contentTopPos + 102, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos + 110, this.contentTopPos - 7, this.contentLeftPos + 168, this.contentTopPos + 101, -5592406);
    }
}

