/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.menu.configuration.skin.CustomSkinConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class CustomSkinConfigurationScreen
extends SkinConfigurationScreen<CustomSkinConfigurationMenu> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_RELOAD_DELAY = 5;
    protected static int nextSkinReload = (int)Instant.now().getEpochSecond();
    protected final SkinData<?> skinData;
    protected Button skinFolderButton;
    protected Button skinReloadButton;
    protected int numberOfTextLines;
    protected int lastNumOfSkins;
    private List<FormattedCharSequence> textComponents;

    public CustomSkinConfigurationScreen(CustomSkinConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.skinData = this.easyNPC.getEasyNPCSkinData();
        this.skinFolderButton = null;
        this.skinReloadButton = null;
        this.numberOfTextLines = 1;
        this.lastNumOfSkins = 0;
        this.textComponents = Collections.emptyList();
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.easyNPC == null) {
            return;
        }
        int positionTop = 119;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        Set<UUID> textures = CustomTextureManager.getCustomTextureCacheKeys(this.skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.f_97735_ + 32 + skinPosition * 60;
            int top = this.f_97736_ + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, this.skinModel, textureKey);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(guiGraphics, this.f_96547_, variantName, leftNamePos, topNamePos, 43520);
            guiGraphics.m_280168_().m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(GuiGraphics guiGraphics, int x, int y, SkinModel skinModel, UUID textureUUID) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> ServerNetworkMessageHandler.skinChange(this.uuid, "", "", textureUUID, SkinType.CUSTOM));
        UUID skinUUID = this.skinData.getSkinUUID();
        skinButton.f_93623_ = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityPlayerSkin(x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.easyNPC, textureUUID, SkinType.CUSTOM);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customSkinButton.f_93623_ = false;
        this.numOfSkins = CustomTextureManager.getCustomTextureCacheKeys(this.skinModel).size();
        int skinButtonTop = this.f_97736_ + 187;
        int skinButtonLeft = this.contentLeftPos;
        int skinButtonRight = this.rightPos - 31;
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
        Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(this.skinModel);
        if (skinModelFolder != null) {
            this.skinFolderButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 10, skinButtonTop - 114, 263, "open_textures_folder", (Object)this.skinModel.toString(), onPress -> Util.m_137581_().m_137644_(skinModelFolder.toFile())));
        }
        this.skinReloadButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 70, skinButtonTop, 160, "reload_textures", onPress -> {
            CustomSkinDataFiles.refreshRegisterTextureFiles();
            nextSkinReload = (int)Instant.now().getEpochSecond() + 5;
        }));
        this.textComponents = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"text.easy_npc.config.custom_skin_text"), this.f_97726_ - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        boolean canSkinReload;
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.f_96547_);
                Text.drawString(guiGraphics, this.f_96547_, formattedCharSequence, this.f_97735_ + 10, this.f_97736_ + 45 + line * (9 + 2));
            }
        }
        boolean bl = canSkinReload = Instant.now().getEpochSecond() >= (long)nextSkinReload;
        if (!canSkinReload) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "skin_reloading", this.f_97735_ + 55, this.f_97736_ + 215, 0xFF5555);
        }
        this.skinReloadButton.f_93623_ = canSkinReload;
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.m_88315_(guiGraphics, x, y, partialTicks);
            }
        }
        this.renderSkins(guiGraphics);
    }
}

