/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.trading;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.trading.TradingConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.menu.configuration.trading.AdvancedTradingConfigurationMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedTradingConfigurationScreen
extends TradingConfigurationScreen<AdvancedTradingConfigurationMenu> {
    protected static final int NAVIGATION_TICKER = 20;
    protected static final int TRADING_OFFERS_TICKER = 20;
    protected final HashMap<Integer, EditBox> maxUsesEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> rewardExpEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> priceMultiplierEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> demandEditBoxes = new HashMap();
    protected final TradingData<?> tradingData = this.easyNPC.getEasyNPCTradingData();
    protected Button previousPageButton;
    protected Button nextPageButton;
    protected EditBox resetsEveryMinEditBox;
    private int navigationTicker = 20;
    private int tradingOffersTicker = 20;

    public AdvancedTradingConfigurationScreen(AdvancedTradingConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (AdvancedTradingConfigurationScreen.isNumericValue(text) && !text.isEmpty()) {
            ServerNetworkMessageHandler.setAdvancedTradingResetsEveryMin(this.uuid, Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && AdvancedTradingConfigurationScreen.isPositiveNumericValue(value) && !value.isEmpty()) {
            ServerNetworkMessageHandler.setAdvancedTradingMaxUses(this.uuid, offerIndex, Integer.parseInt(value));
        }
    }

    private void onRewardExpEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && AdvancedTradingConfigurationScreen.isNumericValue(value) && !value.isEmpty()) {
            ServerNetworkMessageHandler.setAdvancedTradingRewardExp(this.uuid, offerIndex, Integer.parseInt(value));
        }
    }

    private void onPriceMultiplierEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && AdvancedTradingConfigurationScreen.isFloatValue(value) && !value.isEmpty()) {
            ServerNetworkMessageHandler.setAdvancedTradingPriceMultiplier(this.uuid, offerIndex, Float.parseFloat(value));
        }
    }

    private void onDemandEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && AdvancedTradingConfigurationScreen.isNumericValue(value) && !value.isEmpty()) {
            ServerNetworkMessageHandler.setAdvancedTradingDemand(this.uuid, offerIndex, Integer.parseInt(value));
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedTradesButton.f_93623_ = false;
        this.resetsEveryMinEditBox = new TextField(this.f_96547_, this.contentLeftPos + 250, this.contentTopPos + 172, 32);
        this.resetsEveryMinEditBox.m_94199_(3);
        this.resetsEveryMinEditBox.m_94144_("" + this.tradingData.getTradingResetsEveryMin());
        this.resetsEveryMinEditBox.m_94151_(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isNumericValue(x$0));
        this.m_142416_((GuiEventListener)this.resetsEveryMinEditBox);
        int editBoxPositionX = this.contentLeftPos + 140;
        int editBoxPositionY = this.f_97736_ + 60;
        MerchantOffers merchantOffers = this.tradingData.getTradingOffers();
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() * 5 + tradingOffer;
            MerchantOffer merchantOffer = merchantOffers.size() > tradingOfferIndex ? (MerchantOffer)merchantOffers.get(tradingOfferIndex) : new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, 0, 0, 0, 0.0f);
            boolean hasValidOffer = (!merchantOffer.m_45352_().m_41619_() || !merchantOffer.m_45364_().m_41619_()) && !merchantOffer.m_45368_().m_41619_();
            log.info("Trading Offer {} : {}", (Object)tradingOfferIndex, (Object)merchantOffer.m_45384_());
            PositiveNumberField maxUsesEditBox = new PositiveNumberField(this.f_96547_, editBoxPositionX, editBoxPositionY, 32);
            maxUsesEditBox.m_94199_(4);
            maxUsesEditBox.m_94144_((String)(merchantOffer.m_45373_() > 0 ? "" + merchantOffer.m_45373_() : "16"));
            maxUsesEditBox.m_94151_(text -> this.onMaxUsesEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.m_45373_()));
            maxUsesEditBox.m_94186_(hasValidOffer);
            this.maxUsesEditBoxes.put(tradingOfferIndex, maxUsesEditBox);
            this.m_142416_((GuiEventListener)maxUsesEditBox);
            TextField rewardExpEditBox = new TextField(this.f_96547_, editBoxPositionX + 45, editBoxPositionY, 26);
            rewardExpEditBox.m_94199_(3);
            rewardExpEditBox.m_94144_((String)(merchantOffer.m_45379_() >= 0 ? "" + merchantOffer.m_45379_() : "0"));
            rewardExpEditBox.m_94151_(text -> this.onRewardExpEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.m_45379_()));
            rewardExpEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isNumericValue(x$0));
            rewardExpEditBox.m_94186_(hasValidOffer);
            this.rewardExpEditBoxes.put(tradingOfferIndex, rewardExpEditBox);
            this.m_142416_((GuiEventListener)rewardExpEditBox);
            TextField priceMultiplierEditBox = new TextField(this.f_96547_, editBoxPositionX + 85, editBoxPositionY, 32);
            priceMultiplierEditBox.m_94199_(4);
            priceMultiplierEditBox.m_94144_((String)(merchantOffer.m_45378_() >= 0.0f ? "" + merchantOffer.m_45378_() : "0"));
            priceMultiplierEditBox.m_94151_(text -> this.onPriceMultiplierEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.m_45378_()));
            priceMultiplierEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isFloatValue(x$0));
            priceMultiplierEditBox.m_94186_(hasValidOffer);
            this.priceMultiplierEditBoxes.put(tradingOfferIndex, priceMultiplierEditBox);
            this.m_142416_((GuiEventListener)priceMultiplierEditBox);
            TextField demandEditBox = new TextField(this.f_96547_, editBoxPositionX + 135, editBoxPositionY, 20);
            demandEditBox.m_94199_(2);
            demandEditBox.m_94144_((String)(merchantOffer.m_45375_() >= 0 ? "" + merchantOffer.m_45375_() : "0"));
            demandEditBox.m_94151_(text -> this.onDemandEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.m_45375_()));
            demandEditBox.m_94153_(x$0 -> TradingConfigurationScreen.isNumericValue(x$0));
            demandEditBox.m_94186_(hasValidOffer);
            this.demandEditBoxes.put(tradingOfferIndex, demandEditBox);
            this.m_142416_((GuiEventListener)demandEditBox);
            editBoxPositionY += 19;
        }
        this.previousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.contentTopPos + 115, 70, "previous_page", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_TRADING, ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() - 1)));
        this.nextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 235, this.contentTopPos + 115, 70, "next_page", onPress -> ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_TRADING, ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() + 1)));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.navigationTicker++ > 20) {
            if (this.previousPageButton != null) {
                boolean bl = this.previousPageButton.f_93623_ = ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() > 0;
            }
            if (this.nextPageButton != null) {
                this.nextPageButton.f_93623_ = ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() < ((AdvancedTradingConfigurationMenu)this.f_97732_).getMaxPages() - 1;
            }
            this.navigationTicker = 0;
        }
        if (this.tradingOffersTicker++ > 20) {
            for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
                EditBox demandEditBox;
                EditBox priceMultiplierEditBox;
                EditBox rewardExpEditBox;
                int tradingOfferIndex = ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() * 5 + tradingOffer;
                MerchantOffers merchantOffers = this.tradingData.getTradingOffers();
                MerchantOffer merchantOffer = merchantOffers.size() > tradingOfferIndex ? (MerchantOffer)merchantOffers.get(tradingOfferIndex) : new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, 16, 0, 0, 0.0f);
                boolean hasValidOffer = (!merchantOffer.m_45352_().m_41619_() || !merchantOffer.m_45364_().m_41619_()) && !merchantOffer.m_45368_().m_41619_();
                EditBox maxUsesEditBox = this.maxUsesEditBoxes.get(tradingOfferIndex);
                if (maxUsesEditBox != null) {
                    maxUsesEditBox.m_94186_(hasValidOffer);
                }
                if ((rewardExpEditBox = this.rewardExpEditBoxes.get(tradingOfferIndex)) != null) {
                    rewardExpEditBox.m_94186_(hasValidOffer);
                }
                if ((priceMultiplierEditBox = this.priceMultiplierEditBoxes.get(tradingOfferIndex)) != null) {
                    priceMultiplierEditBox.m_94186_(hasValidOffer);
                }
                if ((demandEditBox = this.demandEditBoxes.get(tradingOfferIndex)) == null) continue;
                demandEditBox.m_94186_(hasValidOffer);
            }
            this.tradingOffersTicker = 0;
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.m_280072_(guiGraphics, x, y);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        int legendTopPositionY = this.contentTopPos + 2;
        Text.drawString(guiGraphics, this.f_96547_, "Cost A", this.f_97735_ + 18, legendTopPositionY, 0xA04040);
        Text.drawString(guiGraphics, this.f_96547_, "Cost B", this.f_97735_ + 60, legendTopPositionY, 0x40A040);
        Text.drawString(guiGraphics, this.f_96547_, "Result", this.f_97735_ + 102, legendTopPositionY, 0x4040A0);
        Text.drawString(guiGraphics, this.f_96547_, "Max Uses", this.f_97735_ + 140, legendTopPositionY, 16448);
        Text.drawString(guiGraphics, this.f_96547_, "XP", this.f_97735_ + 198, legendTopPositionY, 0x400040);
        Text.drawString(guiGraphics, this.f_96547_, "Multiplier", this.f_97735_ + 225, legendTopPositionY, 0x404040);
        Text.drawString(guiGraphics, this.f_96547_, "Demand", this.f_97735_ + 275, legendTopPositionY, 0x404000);
        int slotPositionX = this.f_97735_ + 30 - 1;
        int slotPositionY = this.f_97736_ + 60 - 1;
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((AdvancedTradingConfigurationMenu)this.f_97732_).getPageIndex() * 5 + tradingOffer;
            Text.drawString(guiGraphics, this.f_96547_, (tradingOfferIndex < 9 ? " " : "") + (tradingOfferIndex + 1) + ".", slotPositionX - 15, slotPositionY + 5, 0x404040);
            int itemASlotTopPosition = slotPositionY;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, slotPositionX, itemASlotTopPosition, 7, 7, 18, 18);
            Text.drawString(guiGraphics, this.f_96547_, "+", slotPositionX + 18 + 6, itemASlotTopPosition + 5, 0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, itemBSlotLeftPosition, itemBSlotTopPosition, 7, 7, 18, 18);
            Text.drawString(guiGraphics, this.f_96547_, "=", itemBSlotLeftPosition + 18 + 12, itemBSlotTopPosition + 5, 0x404040);
            guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, slotPositionX + 82, slotPositionY, 7, 7, 18, 18);
            slotPositionY += 19;
        }
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 72, this.contentTopPos + 115, 7, 83, 162, 54);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, this.contentLeftPos + 72, this.contentTopPos + 171, 7, 141, 162, 18);
        Text.drawConfigString(guiGraphics, this.f_96547_, "trading.minutes_for_trade_reset", this.contentLeftPos + 236, this.contentTopPos + 160, 0x404040);
    }
}

