/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.editor.DialogButtonEditorMenu;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogButtonEditorScreen
extends AbstractContainerScreen<DialogButtonEditorMenu> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final ClientLevel clientLevel;
    protected final LocalPlayer localPlayer;
    protected final Minecraft minecraftInstance;
    protected final DialogDataSet dialogDataSet;
    protected final DialogDataEntry dialogData;
    protected final DialogButtonData dialogButtonData;
    protected final EasyNPC<?> easyNPC;
    protected final UUID dialogId;
    protected final UUID dialogButtonId;
    protected final UUID uuid;
    protected final ConfigurationType formerConfigurationType;
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogButtonButton;
    protected Button closeButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField buttonNameBox;
    protected Button buttonNameToLabelButton;
    protected TextField buttonLabelBox;
    protected Checkbox buttonLabelCheckbox;
    protected TextField openNamedDialogBox;
    protected Checkbox openTradingScreenCheckbox;
    protected TextField commandDialogBox;
    protected Checkbox commandDialogExecuteAsUserCheckbox;
    protected Checkbox commandDialogDebugCheckbox;
    protected int bottomPos;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    private String buttonNameValue = "";
    private String buttonLabelValue = "";
    private String openNamedDialogValue = "";
    private String commandDialogValue = "";
    private boolean openTradingScreenValue = false;
    private boolean commandDialogExecuteAsUserValue = false;
    private boolean commandDialogDebugValue = false;

    @OnlyIn(value=Dist.CLIENT)
    public DialogButtonEditorScreen(DialogButtonEditorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.uuid = menu.getUUID();
        this.easyNPC = menu.getEasyNPC();
        this.dialogDataSet = menu.getDialogDataSet();
        this.dialogData = this.dialogDataSet.getDialog(menu.getDialogId());
        this.dialogButtonData = menu.getDialogButtonData();
        this.dialogId = menu.getDialogId();
        this.dialogButtonId = menu.getDialogButtonId();
        this.formerConfigurationType = menu.getFormerConfigurationType();
        this.minecraftInstance = Minecraft.m_91087_();
        this.localPlayer = this.minecraftInstance.f_91074_;
        this.clientLevel = this.minecraftInstance.f_91073_;
    }

    private void openPreviousScreen() {
        if (this.formerConfigurationType == ConfigurationType.DIALOG_EDITOR) {
            ServerNetworkMessageHandler.openDialogEditor(this.uuid, this.dialogId, this.formerConfigurationType);
        } else if (this.formerConfigurationType == ConfigurationType.ADVANCED_DIALOG) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.ADVANCED_DIALOG);
        } else if (this.formerConfigurationType != null) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, this.formerConfigurationType);
        } else if (this.dialogDataSet.getType() == DialogType.YES_NO) {
            ServerNetworkMessageHandler.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
        } else {
            this.closeScreen();
        }
    }

    private void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
    }

    private void deleteDialogButton() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                ServerNetworkMessageHandler.removeDialogButton(this.uuid, this.dialogId, this.dialogButtonId);
                this.openPreviousScreen();
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)Component.m_237115_((String)"text.easy_npc.removeDialogButton.deleteQuestion"), (Component)Component.m_237110_((String)"text.easy_npc.removeDialogButton.deleteWarning", (Object[])new Object[]{this.dialogButtonData.getName()}), (Component)Component.m_237115_((String)"text.easy_npc.removeDialogButton.deleteButton"), CommonComponents.f_130656_));
    }

    protected void renderEditLabels(GuiGraphics guiGraphics) {
        Text.drawConfigString(guiGraphics, this.f_96547_, "button.name", this.f_97735_ + 12, this.buttonNameBox.m_252907_() + 4);
        Text.drawConfigString(guiGraphics, this.f_96547_, "label_id", this.f_97735_ + 12, this.buttonLabelBox.m_252907_() + 4);
        Text.drawConfigString(guiGraphics, this.f_96547_, "dialog_actions_on_click", this.f_97735_ + 12, this.openNamedDialogBox.m_252907_() - 16, 0);
        Text.drawConfigString(guiGraphics, this.f_96547_, "open_named_dialog", this.f_97735_ + 12, this.openNamedDialogBox.m_252907_() + 4);
        Text.drawString(guiGraphics, this.f_96547_, "Actions", this.f_97735_ + 12, this.commandDialogBox.m_252907_() - 10);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97727_ = 243;
        this.f_97726_ = 318;
        this.f_97728_ = 8;
        this.f_97729_ = 7;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        ActionDataEntry openNamedDialogAction = this.dialogButtonData.getActionData(ActionType.OPEN_NAMED_DIALOG);
        ActionDataEntry openTradingScreenAction = this.dialogButtonData.getActionData(ActionType.OPEN_TRADING_SCREEN);
        ActionDataEntry commandAction = this.dialogButtonData.getActionData(ActionType.COMMAND);
        this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.f_97735_ + 7, this.f_97736_ + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.m_252754_() + this.homeButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogData.getName(21), onPress -> this.openPreviousScreen()));
        this.dialogButtonButton = (Button)this.m_142416_((GuiEventListener)new DialogButtonButton(this.dialogButton.m_252754_() + this.dialogButton.m_5711_(), this.f_97736_ + 7, 140, this.dialogButtonData.getName(21), onPress -> {}));
        this.dialogButtonButton.f_93623_ = false;
        this.buttonNameValue = this.dialogButtonData.getName();
        this.buttonNameBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 30, 150);
        this.buttonNameBox.m_94199_(64);
        this.buttonNameBox.m_94144_(this.buttonNameValue);
        this.m_142416_((GuiEventListener)this.buttonNameBox);
        this.buttonNameToLabelButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.buttonNameBox.m_252754_() + this.buttonNameBox.m_5711_() + 1, this.buttonNameBox.m_252907_() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.buttonNameBox != null && this.buttonLabelBox != null) {
                String buttonName = this.buttonNameBox.m_94155_();
                this.buttonLabelBox.m_94144_(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.buttonLabelValue = this.dialogButtonData.getLabel();
        this.buttonLabelBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 50, 100);
        this.buttonLabelBox.m_94199_(32);
        this.buttonLabelBox.m_94144_(this.buttonLabelValue);
        this.buttonLabelBox.m_94186_(false);
        this.m_142416_((GuiEventListener)this.buttonLabelBox);
        this.buttonLabelCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 204, this.buttonLabelBox.m_252907_() + 1, "locked", true, onPress -> this.buttonLabelBox.m_94186_(!this.buttonLabelCheckbox.selected())));
        this.openNamedDialogValue = openNamedDialogAction != null ? openNamedDialogAction.getCommand() : "";
        this.openNamedDialogBox = new TextField(this.f_96547_, this.f_97735_ + 100, this.f_97736_ + 90, 100);
        this.openNamedDialogBox.m_94199_(32);
        this.openNamedDialogBox.m_94144_(this.openNamedDialogValue);
        this.openNamedDialogBox.m_94186_(openTradingScreenAction == null || openTradingScreenAction.getCommand() == null);
        this.m_142416_((GuiEventListener)this.openNamedDialogBox);
        this.openTradingScreenValue = openTradingScreenAction != null && openTradingScreenAction.getCommand() != null;
        this.openTradingScreenCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 100 + 104, this.openNamedDialogBox.m_252907_() + 1, "open_trading_screen", this.openTradingScreenValue, onPress -> this.openNamedDialogBox.m_94186_(!this.openTradingScreenCheckbox.selected())));
        this.commandDialogValue = commandAction != null ? commandAction.getCommand() : "";
        this.commandDialogBox = new TextField(this.f_96547_, this.f_97735_ + 10, this.f_97736_ + 130, 295);
        this.commandDialogBox.m_94199_(255);
        this.commandDialogBox.m_94144_(this.commandDialogValue);
        this.m_142416_((GuiEventListener)this.commandDialogBox);
        this.commandDialogExecuteAsUserValue = commandAction != null && commandAction.shouldExecuteAsUser();
        this.commandDialogExecuteAsUserCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 10 + 80, this.commandDialogBox.m_252907_() + 18, "execute_as_player", this.commandDialogExecuteAsUserValue));
        this.commandDialogDebugValue = commandAction != null && commandAction.isDebugEnabled();
        this.commandDialogDebugCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.f_97735_ + 10 + 215, this.commandDialogBox.m_252907_() + 18, "debug", this.commandDialogDebugValue));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.f_97735_ + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.dialogButtonData.setName(this.buttonNameBox.m_94155_());
            this.dialogButtonData.setLabel(this.buttonLabelBox.m_94155_());
            HashSet<ActionDataEntry> actionDataEntrySet = new HashSet<ActionDataEntry>();
            if (this.openTradingScreenCheckbox.selected()) {
                ActionDataEntry openTradingScreenActionDataEntry = new ActionDataEntry(ActionType.OPEN_TRADING_SCREEN);
                actionDataEntrySet.add(openTradingScreenActionDataEntry);
            } else if (!this.openNamedDialogBox.m_94155_().isEmpty()) {
                ActionDataEntry openNamedDialogActionDataEntry = new ActionDataEntry(ActionType.OPEN_NAMED_DIALOG, this.openNamedDialogBox.m_94155_());
                actionDataEntrySet.add(openNamedDialogActionDataEntry);
            }
            ActionDataEntry commandActionDataEntry = new ActionDataEntry(ActionType.COMMAND, this.commandDialogBox.m_94155_(), this.commandDialogExecuteAsUserCheckbox.selected(), this.commandDialogDebugCheckbox.selected());
            actionDataEntrySet.add(commandActionDataEntry);
            this.dialogButtonData.setActionData(actionDataEntrySet);
            ServerNetworkMessageHandler.saveDialogButton(this.uuid, this.dialogId, this.dialogButtonId, this.dialogButtonData);
            this.openPreviousScreen();
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.m_252754_() + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialogButton()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.m_252754_() + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.buttonNameBox.m_94155_().equals(this.buttonNameValue) || !this.buttonLabelBox.m_94155_().equals(this.buttonLabelValue) || !this.openNamedDialogBox.m_94155_().equals(this.openNamedDialogValue) || !this.commandDialogBox.m_94155_().equals(this.commandDialogValue) || this.openTradingScreenCheckbox.selected() != this.openTradingScreenValue || this.commandDialogExecuteAsUserCheckbox.selected() != this.commandDialogExecuteAsUserValue || this.commandDialogDebugCheckbox.selected() != this.commandDialogDebugValue;
        }
        if (this.buttonLabelCheckbox != null && this.buttonNameToLabelButton != null) {
            this.buttonNameToLabelButton.f_93623_ = !this.buttonLabelCheckbox.selected();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        this.xMouse = x;
        this.yMouse = y;
        if (this.buttonNameToLabelButton.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"text.easy_npc.config.name_to_label.tooltip"), x, y);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, 210, 160);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_ + 203, this.f_97736_, 132, 0, 120, 160);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_, this.f_97736_ + 77, 0, 5, 210, 170);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, this.f_97735_ + 203, this.f_97736_ + 77, 132, 5, 120, 170);
        guiGraphics.m_280509_(this.f_97735_ + 6, this.f_97736_ + 110, this.rightPos - 6, this.commandDialogBox.m_252907_() + 70, -16777216);
        guiGraphics.m_280509_(this.f_97735_ + 7, this.f_97736_ + 111, this.rightPos - 7, this.commandDialogBox.m_252907_() + 69, -2236963);
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

