/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final HashMap<TextureModelKey, ResourceLocation> textureCache = new HashMap();
    private static final HashMap<TextureModelKey, SkinType> textureSkinTypeCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();

    private PlayerTextureManager() {
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !PlayerTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey);
    }

    public static ResourceLocation getOrCreateTextureWithDefault(SkinData<?> skinData, ResourceLocation defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        ResourceLocation resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            if (!PlayerTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            }
            return resourceLocation;
        }
        UUID playerUUID = skinData.getSkinUUID();
        ResourceLocation createdResourceLocation = PlayerTextureManager.createTexture(textureModelKey, skinData, playerUUID);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinData<?> skinData, UUID playerUUID) {
        if (!textureReloadProtection.add(playerUUID)) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = PlayerSkinDataFiles.getPlayerSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        ResourceLocation localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            return localTextureCache;
        }
        String playerSkinUrl = PlayersUtils.getUserTexture(playerUUID);
        ResourceLocation resourceLocation = TextureManager.addRemoteTexture(textureModelKey, playerSkinUrl, textureDataFolder);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            return resourceLocation;
        }
        log.error("Unable to load player {} texture {} from {}!", (Object)playerUUID, (Object)textureModelKey, (Object)textureDataFolder);
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        PlayerTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }
}

