/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.util.Objects;
import java.util.UUID;

public class TextureModelKey {
    private final UUID uuid;
    private final String subType;
    private final SkinModel skinModel;

    public TextureModelKey(UUID uuid, SkinModel skinModel) {
        this.uuid = uuid;
        this.subType = skinModel != null ? skinModel.name() : "";
        this.skinModel = skinModel;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSubType() {
        return this.subType;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.subType);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextureModelKey)) {
            return false;
        }
        TextureModelKey textureModelKey = (TextureModelKey)object;
        return this.uuid.equals(textureModelKey.uuid) && this.subType.equals(textureModelKey.subType);
    }

    public String toString() {
        return "TextureModelKey{uuid=" + this.uuid + ", skinModel=" + this.skinModel + ", subType='" + this.subType + "'}";
    }
}

