/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ActionEventSet {
    public static final String DATA_ACTION_EVENT_SET_TAG = "ActionEventSet";
    protected static final Set<ActionDataEntry> EMPTY_ACTION_DATA_SET = new HashSet<ActionDataEntry>();
    private final EnumMap<ActionEventType, Set<ActionDataEntry>> actionsMap = new EnumMap(ActionEventType.class);
    private boolean hasDistanceActionEvent = false;

    public ActionEventSet() {
    }

    public ActionEventSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public void setActionEvent(ActionEventType actionEventType, ActionDataEntry actionDataEntry) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE && actionDataEntry != null && actionDataEntry.hasCommand()) {
            HashSet<ActionDataEntry> actionDataEntryList = new HashSet<ActionDataEntry>();
            actionDataEntryList.add(actionDataEntry);
            this.actionsMap.put(actionEventType, actionDataEntryList);
            this.updateHasDistanceAction();
        }
    }

    public ActionDataEntry getActionEvent(ActionEventType actionEventType) {
        Set<ActionDataEntry> actions;
        if (actionEventType != null && actionEventType != ActionEventType.NONE && (actions = this.actionsMap.get((Object)actionEventType)) != null && !actions.isEmpty()) {
            return actions.iterator().next();
        }
        return null;
    }

    public Set<ActionDataEntry> getActionEvents(ActionEventType actionEventType) {
        if (actionEventType != ActionEventType.NONE) {
            return this.actionsMap.get((Object)actionEventType);
        }
        return EMPTY_ACTION_DATA_SET;
    }

    public boolean hasActionEvent(ActionEventType actionEventType) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE) {
            Set<ActionDataEntry> actions = this.actionsMap.get((Object)actionEventType);
            return actions != null && !actions.isEmpty();
        }
        return false;
    }

    public void updateHasDistanceAction() {
        this.hasDistanceActionEvent = this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_NEAR) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_NEAR).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_TOUCH) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_TOUCH).isEmpty();
    }

    public void clear() {
        this.actionsMap.clear();
        this.hasDistanceActionEvent = false;
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_ACTION_EVENT_SET_TAG)) {
            return;
        }
        this.clear();
        CompoundTag actionDataSetTag = compoundTag.m_128469_(DATA_ACTION_EVENT_SET_TAG);
        for (ActionEventType actionEventType : ActionEventType.values()) {
            ListTag actionListTag;
            if (!actionDataSetTag.m_128441_(actionEventType.name()) || (actionListTag = actionDataSetTag.m_128437_(actionEventType.name(), 10)).isEmpty()) continue;
            HashSet<ActionDataEntry> actionDataEntryList = new HashSet<ActionDataEntry>();
            for (int i = 0; i < actionListTag.size(); ++i) {
                CompoundTag actionTag = actionListTag.m_128728_(i);
                actionDataEntryList.add(new ActionDataEntry(actionTag));
            }
            this.actionsMap.put(actionEventType, actionDataEntryList);
            this.updateHasDistanceAction();
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag actionsTag = new CompoundTag();
        for (Map.Entry<ActionEventType, Set<ActionDataEntry>> entry : this.actionsMap.entrySet()) {
            ActionEventType actionEventType = entry.getKey();
            Set<ActionDataEntry> actionDataEntryList = entry.getValue();
            ListTag actionListTag = new ListTag();
            for (ActionDataEntry actionDataEntry : actionDataEntryList) {
                actionListTag.add((Object)actionDataEntry.createTag());
            }
            actionsTag.m_128365_(actionEventType.name(), (Tag)actionListTag);
        }
        compoundTag.m_128365_(DATA_ACTION_EVENT_SET_TAG, (Tag)actionsTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "ActionEventSet [ hasDistanceActionEvent=" + this.hasDistanceActionEvent + ", " + this.actionsMap + "]";
    }
}

