/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DialogTextData {
    public static final String DATA_TEXT_TAG = "Text";
    public static final String DATA_TRANSLATE_TAG = "Translate";
    private UUID id;
    private String text;
    private boolean translate;

    public DialogTextData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public DialogTextData(String text) {
        this(text, false);
    }

    public DialogTextData(String text, boolean translate) {
        this.id = UUID.randomUUID();
        this.text = text != null ? text.trim() : "";
        this.translate = translate;
    }

    public UUID getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText(int maxLength) {
        return this.text.length() > maxLength ? this.text.substring(0, maxLength - 1) + "\u2026" : this.text;
    }

    public String getDialogText() {
        return this.translate ? Component.m_237115_((String)this.text).getString() : Component.m_237113_((String)this.text).getString();
    }

    public String getDialogText(LivingEntity entity, Player player) {
        return DialogUtils.parseDialogText(this.getDialogText(), entity, player);
    }

    public boolean getTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public void load(CompoundTag compoundTag) {
        this.text = compoundTag.m_128461_(DATA_TEXT_TAG);
        this.translate = compoundTag.m_128441_(DATA_TRANSLATE_TAG) && compoundTag.m_128471_(DATA_TRANSLATE_TAG);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_TEXT_TAG, this.text.trim());
        if (this.translate) {
            compoundTag.m_128379_(DATA_TRANSLATE_TAG, true);
        }
        return compoundTag;
    }
}

