/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class CrossbowAttackGoal<T extends EasyNPC<?>>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final PathfinderMob pathfinderMob;
    private final CrossbowAttackMob crossbowAttackMob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public CrossbowAttackGoal(T easyNPC, double speedModifier, float attackRange) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.crossbowAttackMob = easyNPC.getCrossbowAttackMob();
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRange * attackRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.crossbowAttackMob != null && this.isValidTarget() && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.pathfinderMob.m_21573_().m_26571_()) && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    private boolean isValidTarget() {
        return this.pathfinderMob.m_5448_() != null && this.pathfinderMob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.pathfinderMob.m_21561_(false);
        this.pathfinderMob.m_6710_(null);
        this.seeTime = 0;
        if (this.pathfinderMob.m_6117_()) {
            this.pathfinderMob.m_5810_();
            this.crossbowAttackMob.m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.pathfinderMob.m_21211_(), (boolean)false);
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.pathfinderMob.m_21561_(true);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.pathfinderMob.m_5448_();
        if (livingentity != null) {
            boolean flag2;
            boolean hasSeen;
            boolean hasLineOfSight = this.pathfinderMob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (hasLineOfSight != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
            double distanceToTarget = this.pathfinderMob.m_20280_((Entity)livingentity);
            boolean bl2 = flag2 = (distanceToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.pathfinderMob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.pathfinderMob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.pathfinderMob.m_21573_().m_26573_();
            }
            this.pathfinderMob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.pathfinderMob.m_6672_(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
                    this.crossbowState = CrossbowState.CHARGING;
                    this.crossbowAttackMob.m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.pathfinderMob.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.pathfinderMob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.pathfinderMob.m_21211_()))) {
                    this.pathfinderMob.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 20 + this.pathfinderMob.m_217043_().m_188503_(20);
                    this.crossbowAttackMob.m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && hasLineOfSight) {
                this.crossbowAttackMob.m_6504_(livingentity, 1.0f);
                ItemStack itemStack1 = this.pathfinderMob.m_21120_(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
                CrossbowItem.m_40884_((ItemStack)itemStack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

