/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.PathfinderMob;

public interface ActionEventData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final EntityDataSerializer<ActionEventSet> ACTION_EVENT_SET = new EntityDataSerializer<ActionEventSet>(){

        public void write(FriendlyByteBuf buffer, ActionEventSet value) {
            buffer.m_130079_(value.createTag());
        }

        public ActionEventSet read(FriendlyByteBuf buffer) {
            return new ActionEventSet(buffer.m_130260_());
        }

        public ActionEventSet copy(ActionEventSet value) {
            return value;
        }
    };
    public static final ServerDataAccessor<ActionEventSet> CUSTOM_DATA_ACTION_EVENT_SET = ServerEntityData.defineId(ServerDataIndex.ACTION_EVENT_SET, ACTION_EVENT_SET);
    public static final ServerDataAccessor<Integer> CUSTOM_DATA_ACTION_PERMISSION_LEVEL = ServerEntityData.defineId(EntityDataSerializers.f_135028_);
    public static final String DATA_ACTION_DATA_TAG = "ActionData";
    public static final String DATA_ACTION_PERMISSION_LEVEL_TAG = "ActionPermissionLevel";

    public static void registerActionEventDataSerializer() {
        EntityDataSerializers.m_135050_(ACTION_EVENT_SET);
    }

    default public ActionEventSet getActionEventSet() {
        return this.getServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET);
    }

    default public void setActionEventSet(ActionEventSet actions) {
        this.setServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, actions);
    }

    default public boolean hasActionEvent(ActionEventType actionEventType) {
        return actionEventType != null && this.getActionEventSet() != null && this.getActionEventSet().hasActionEvent(actionEventType);
    }

    default public ActionDataEntry getActionEvent(ActionEventType actionEventType) {
        return this.hasActionEvent(actionEventType) ? this.getActionEventSet().getActionEvent(actionEventType) : null;
    }

    default public void clearActionEventSet() {
        this.setServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, new ActionEventSet());
    }

    default public int getActionPermissionLevel() {
        return this.getServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL);
    }

    default public void setActionPermissionLevel(int actionPermissionLevel) {
        this.setServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL, actionPermissionLevel);
    }

    default public void defineSynchedActionData() {
    }

    default public void defineCustomActionData() {
        this.defineServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, new ActionEventSet());
        this.defineServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL, 0);
    }

    default public void addAdditionalActionData(CompoundTag compoundTag) {
        CompoundTag actionDataTag = new CompoundTag();
        if (this.isServerSide()) {
            ActionEventSet actionEventSet = this.getActionEventSet();
            if (actionEventSet != null) {
                actionEventSet.save(actionDataTag);
            }
            actionDataTag.m_128405_(DATA_ACTION_PERMISSION_LEVEL_TAG, this.getActionPermissionLevel());
        }
        compoundTag.m_128365_(DATA_ACTION_DATA_TAG, (Tag)actionDataTag);
    }

    default public void readAdditionalActionData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_ACTION_DATA_TAG)) {
            return;
        }
        CompoundTag actionDataTag = compoundTag.m_128469_(DATA_ACTION_DATA_TAG);
        if (actionDataTag.m_128441_("ActionEventSet")) {
            ActionEventSet actionDataSet = new ActionEventSet(actionDataTag);
            this.setActionEventSet(actionDataSet);
        }
        if (actionDataTag.m_128441_(DATA_ACTION_PERMISSION_LEVEL_TAG)) {
            this.setActionPermissionLevel(actionDataTag.m_128451_(DATA_ACTION_PERMISSION_LEVEL_TAG));
        }
    }

    default public void handleActionInteractionEvent(ServerPlayer serverPlayer) {
        if (this.hasActionEvent(ActionEventType.ON_INTERACTION)) {
            ActionDataEntry actionDataEntry = this.getActionEvent(ActionEventType.ON_INTERACTION);
            ActionHandler actionHandler = this.getEasyNPCActionHandler();
            if (actionDataEntry != null && actionDataEntry.isValidAndNotEmpty() && actionHandler != null) {
                actionHandler.executeAction(actionDataEntry, serverPlayer);
            }
        }
    }

    default public void handleActionHurtEvent(DamageSource damageSource, float damage) {
        if (this.hasActionEvent(ActionEventType.ON_HURT)) {
            ActionDataEntry actionDataEntry = this.getActionEvent(ActionEventType.ON_HURT);
            ActionHandler actionHandler = this.getEasyNPCActionHandler();
            if (actionDataEntry != null && actionDataEntry.isValidAndNotEmpty() && actionHandler != null) {
                actionHandler.executeAction(actionDataEntry, damageSource);
            }
        }
    }

    default public void handleActionDieEvent(DamageSource damageSource) {
        if (this.hasActionEvent(ActionEventType.ON_DEATH)) {
            ActionDataEntry actionDataEntry = this.getActionEvent(ActionEventType.ON_DEATH);
            ActionHandler actionHandler = this.getEasyNPCActionHandler();
            if (actionDataEntry != null && actionDataEntry.isValidAndNotEmpty() && actionHandler != null) {
                actionHandler.executeAction(actionDataEntry, damageSource);
            }
        }
    }
}

