/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.dialog.DialogButtonData;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PathfinderMob;

public interface DialogData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final EntityDataSerializer<DialogDataSet> DIALOG_DATA_SET = new EntityDataSerializer<DialogDataSet>(){

        public void write(FriendlyByteBuf buffer, DialogDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public DialogDataSet read(FriendlyByteBuf buffer) {
            return new DialogDataSet(buffer.m_130260_());
        }

        public DialogDataSet copy(DialogDataSet value) {
            return value;
        }
    };
    public static final ServerDataAccessor<DialogDataSet> CUSTOM_DATA_DIALOG_DATA_SET = ServerEntityData.defineId(ServerDataIndex.DIALOG_DATA_SET, DIALOG_DATA_SET);
    public static final String DATA_DIALOG_DATA_TAG = "DialogData";

    public static void registerDialogDataSerializer() {
        EntityDataSerializers.m_135050_(DIALOG_DATA_SET);
    }

    default public int getEntityDialogTop() {
        return 0;
    }

    default public int getEntityDialogLeft() {
        return 0;
    }

    default public int getEntityDialogScaling() {
        return 50;
    }

    default public void openDialogMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        MenuManager.getMenuHandler().openDialogMenu(serverPlayer, easyNPC, dialogId, pageIndex);
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET);
    }

    default public void setDialogDataSet(DialogDataSet dialogDataSet) {
        this.setServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, dialogDataSet);
    }

    default public void clearDialogDataSet() {
        this.setDialogDataSet(new DialogDataSet());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public boolean hasDialog(String dialogLabel) {
        return this.getDialogDataSet().hasDialog(dialogLabel);
    }

    default public boolean hasDialog(UUID dialogId) {
        return this.getDialogDataSet().hasDialog(dialogId);
    }

    default public boolean removeDialog(UUID dialogId) {
        return this.getDialogDataSet().removeDialog(dialogId);
    }

    default public boolean removeDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().removeDialogButton(dialogId, dialogButtonId);
    }

    default public void setDialog(UUID dialogId, DialogDataEntry dialogData) {
        this.getDialogDataSet().setDialog(dialogId, dialogData);
    }

    default public UUID getDialogId(String dialogLabel) {
        return this.getDialogDataSet().getDialogId(dialogLabel);
    }

    default public boolean hasDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().hasDialogButton(dialogId, dialogButtonId);
    }

    default public void openDialog(ServerPlayer serverPlayer) {
        this.openDialog(serverPlayer, this.getDialogDataSet().getDefaultDialogId());
    }

    default public void openDialog(ServerPlayer serverPlayer, String dialogLabel) {
        UUID dialogId = this.getDialogId(dialogLabel);
        this.openDialog(serverPlayer, dialogId == null ? this.getDialogDataSet().getDefaultDialogId() : dialogId);
    }

    default public void openDialog(ServerPlayer serverPlayer, UUID dialogId) {
        MenuManager.getMenuHandler().openDialogMenu(serverPlayer, this, dialogId, 0);
    }

    default public DialogButtonData getDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().getDialogButton(dialogId, dialogButtonId);
    }

    default public void defineSynchedDialogData() {
    }

    default public void defineCustomDialogData() {
        this.defineServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, new DialogDataSet());
    }

    default public void addAdditionalDialogData(CompoundTag compoundTag) {
        DialogDataSet dialogDataSet;
        CompoundTag dialogDataTag = new CompoundTag();
        if (this.isServerSide() && (dialogDataSet = this.getDialogDataSet()) != null) {
            dialogDataSet.save(dialogDataTag);
        }
        compoundTag.m_128365_(DATA_DIALOG_DATA_TAG, (Tag)dialogDataTag);
    }

    default public void readAdditionalDialogData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_DIALOG_DATA_TAG)) {
            return;
        }
        CompoundTag dialogDataTag = compoundTag.m_128469_(DATA_DIALOG_DATA_TAG);
        if (dialogDataTag.m_128441_("DialogDataSet")) {
            DialogDataSet dialogDataSet = new DialogDataSet(dialogDataTag);
            this.setDialogDataSet(dialogDataSet);
        }
    }
}

