/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.config.CommonConfig;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.MenuHandlerInterface;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.menu.configuration.action.BasicActionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.action.DialogActionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.action.DistanceActionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.attribute.AbilitiesAttributeConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.attribute.BaseAttributeConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.attribute.DisplayAttributeConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.AdvancedDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.BasicDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.NoneDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.dialog.YesNoDialogConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.main.MainConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.objective.AttackObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.objective.BasicObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.objective.FollowObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.objective.LookObjectiveConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.AdvancedPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.CustomPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.pose.DefaultPoseConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.position.DefaultPositionConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.CustomExportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.CustomImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.DefaultImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.LocalImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.WorldExportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.preset.WorldImportPresetConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.rotation.DefaultRotationConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.scaling.ScalingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.CustomSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.DefaultSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.NoneSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.PlayerSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.skin.UrlSkinConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.AdvancedTradingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.BasicTradingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.CustomTradingConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.trading.NoneTradingConfigurationMenu;
import de.markusbordihn.easynpc.menu.editor.DialogButtonEditorMenu;
import de.markusbordihn.easynpc.menu.editor.DialogEditorMenu;
import de.markusbordihn.easynpc.menu.editor.DialogTextEditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.NetworkHooks;

public class MenuHandler
implements MenuHandlerInterface {
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;

    public static void openEquipmentConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.equipmentConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.equipmentConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.equipmentConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)EquipmentConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBasicActionConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.basicActionConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.basicActionConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.basicActionConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ActionEventSet actionDataSet = easyNPC.getEasyNPCActionEventData().getActionEventSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicActionConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), actionDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(actionDataSet.createTag());
            });
        }
    }

    public static void openDialogActionConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.dialogActionConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.dialogActionConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.dialogActionConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ActionEventSet actionDataSet = easyNPC.getEasyNPCActionEventData().getActionEventSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogActionConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), actionDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(actionDataSet.createTag());
            });
        }
    }

    public static void openDistanceActionConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.distanceActionConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.distanceActionConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.distanceActionConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ActionEventSet actionDataSet = easyNPC.getEasyNPCActionEventData().getActionEventSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DistanceActionConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), actionDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(actionDataSet.createTag());
            });
        }
    }

    public static void openBasicDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.basicDialogConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.basicDialogConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.basicDialogConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicDialogConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(dialogDataSet.createTag());
            });
        }
    }

    public static void openYesNoDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.yesNoDialogConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.yesNoDialogConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.yesNoDialogConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)YesNoDialogConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(dialogDataSet.createTag());
            });
        }
    }

    public static void openAdvancedDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.advancedDialogConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.advancedDialogConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.advancedDialogConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AdvancedDialogConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(dialogDataSet.createTag());
            });
        }
    }

    public static void openMainConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.mainConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.mainConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.mainConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            DialogType dialogType = easyNPC.getEasyNPCDialogData().getDialogDataSet().getType();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)MainConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogType), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130068_((Enum)dialogType);
            });
        }
    }

    public static void openAdvancedPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.advancedPoseConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.advancedPoseConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.advancedPoseConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AdvancedPoseConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.customPoseConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.customPoseConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.customPoseConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomPoseConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPoseConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.defaultPoseConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.defaultPoseConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.defaultPoseConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultPoseConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPositionConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.defaultPositionConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.defaultPositionConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.defaultPositionConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultPositionConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultRotationConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.defaultRotationConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.defaultRotationConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.defaultRotationConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultRotationConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.customSkinConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.customSkinConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.customSkinConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomSkinConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.defaultSkinConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.defaultSkinConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.defaultSkinConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultSkinConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openNoneSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.noneSkinConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.noneSkinConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.noneSkinConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)NoneSkinConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openNoneDialogConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.noneDialogConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.noneDialogConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.noneDialogConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)NoneDialogConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(dialogDataSet.createTag());
            });
        }
    }

    public static void openPlayerSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.playerSkinConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.playerSkinConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.playerSkinConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)PlayerSkinConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openUrlSkinConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.urlSkinConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.urlSkinConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.urlSkinConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)UrlSkinConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openScalingConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.scalingConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.scalingConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.scalingConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)ScalingConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomPresetExportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.customExportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.customExportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.customExportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomExportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openWorldPresetExportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.worldExportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.worldExportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.worldExportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)WorldExportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openDefaultPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.defaultImportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.defaultImportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.defaultImportPresetConfigurationPermissionLevel.get())) {
            NetworkMessageHandlerManager.getClientHandler().syncDefaultPresets(serverPlayer);
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DefaultImportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openServerPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.worldImportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.worldImportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.worldImportPresetConfigurationPermissionLevel.get())) {
            NetworkMessageHandlerManager.getClientHandler().syncWorldPresets(serverPlayer);
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)WorldImportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openCustomPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.customImportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.customImportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.customImportPresetConfigurationPermissionLevel.get())) {
            NetworkMessageHandlerManager.getClientHandler().syncCustomPresets(serverPlayer);
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomImportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openNoneTradingConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.noneTradingConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.noneTradingConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.noneTradingConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)NoneTradingConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBasicTradingConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.basicTradingConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.basicTradingConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.basicTradingConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicTradingConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openAdvancedTradingConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.advancedTradingConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.advancedTradingConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.advancedTradingConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AdvancedTradingConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), pageIndex), buffer -> buffer.m_130077_(uuid).writeInt(pageIndex));
        }
    }

    public static void openCustomTradingConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.customTradingConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.customTradingConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.customTradingConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)CustomTradingConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBasicObjectiveConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.basicObjectiveConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.basicObjectiveConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.basicObjectiveConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ObjectiveDataSet objectiveDataSet = easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BasicObjectiveConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), objectiveDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(objectiveDataSet.createTag());
            });
        }
    }

    public static void openAttackObjectiveConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.attackObjectiveConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.attackObjectiveConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.attackObjectiveConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ObjectiveDataSet objectiveDataSet = easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AttackObjectiveConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), objectiveDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(objectiveDataSet.createTag());
            });
        }
    }

    public static void openFollowObjectiveConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.followObjectiveConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.followObjectiveConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.followObjectiveConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ObjectiveDataSet objectiveDataSet = easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)FollowObjectiveConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), objectiveDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(objectiveDataSet.createTag());
            });
        }
    }

    public static void openLookObjectiveConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.lookObjectiveConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.lookObjectiveConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.lookObjectiveConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            ObjectiveDataSet objectiveDataSet = easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)LookObjectiveConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity(), objectiveDataSet), buffer -> {
                buffer.m_130077_(uuid);
                buffer.m_130079_(objectiveDataSet.createTag());
            });
        }
    }

    public static void openAbilitiesAttributeConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.abilitiesAttributeConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.abilitiesAttributeConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.abilitiesAttributeConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)AbilitiesAttributeConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    public static void openBaseAttributeConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.baseAttributeConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.baseAttributeConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.baseAttributeConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            LivingEntity livingEntity = easyNPC.getLivingEntity();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)BaseAttributeConfigurationMenu.getMenuProvider(uuid, livingEntity), buffer -> {
                buffer.m_130077_(uuid);
                buffer.writeDouble(livingEntity.m_21051_(Attributes.f_22277_) != null ? livingEntity.m_21051_(Attributes.f_22277_).m_22115_() : 32.0);
                buffer.writeDouble(livingEntity.m_21051_(Attributes.f_22278_) != null ? livingEntity.m_21051_(Attributes.f_22278_).m_22115_() : 0.0);
                buffer.writeDouble(livingEntity.m_21051_(Attributes.f_22281_) != null ? livingEntity.m_21051_(Attributes.f_22281_).m_22115_() : 2.0);
                buffer.writeDouble(livingEntity.m_21051_(Attributes.f_22282_) != null ? livingEntity.m_21051_(Attributes.f_22282_).m_22115_() : 0.0);
            });
        }
    }

    public static void openDisplayAttributeConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.displayAttributeConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.displayAttributeConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.displayAttributeConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DisplayAttributeConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    private static boolean hasPermissions(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, Boolean enabled, Boolean allowInCreative, int permissionLevel) {
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (Boolean.FALSE.equals(enabled) || serverPlayer == null) {
            return false;
        }
        if (Boolean.TRUE.equals(allowInCreative) && serverPlayer.m_7500_()) {
            return true;
        }
        if (!ownerData.hasOwner() || !ownerData.isOwner(serverPlayer)) {
            return false;
        }
        return serverPlayer.m_20310_(permissionLevel);
    }

    @Override
    public void openDialogTextEditorMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, ConfigurationType formerConfigurationType, int pageIndex) {
        UUID uuid = easyNPC.getUUID();
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogTextEditorMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet, dialogId, formerConfigurationType, pageIndex), buffer -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(dialogDataSet.createTag());
            buffer.m_130077_(dialogId);
            buffer.m_130068_((Enum)formerConfigurationType);
            buffer.writeInt(pageIndex);
        });
    }

    @Override
    public void openDialogEditorMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, ConfigurationType formerConfigurationType, int pageIndex) {
        UUID uuid = easyNPC.getUUID();
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogEditorMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet, dialogId, formerConfigurationType, pageIndex), buffer -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(dialogDataSet.createTag());
            buffer.m_130077_(dialogId);
            buffer.m_130068_((Enum)formerConfigurationType);
            buffer.writeInt(pageIndex);
        });
    }

    @Override
    public void openDialogButtonEditorMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, ConfigurationType formerConfigurationType, int pageIndex) {
        UUID uuid = easyNPC.getUUID();
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)DialogButtonEditorMenu.getMenuProvider(uuid, easyNPC.getEntity(), dialogDataSet, dialogId, dialogButtonId, formerConfigurationType, pageIndex), buffer -> {
            buffer.m_130077_(uuid);
            buffer.m_130079_(dialogDataSet.createTag());
            buffer.m_130077_(dialogId);
            buffer.m_130077_(dialogButtonId);
            buffer.m_130068_((Enum)formerConfigurationType);
            buffer.writeInt(pageIndex);
        });
    }

    @Override
    public void openConfigurationMenu(ConfigurationType configurationType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        switch (configurationType) {
            case ATTACK_OBJECTIVE: {
                MenuHandler.openAttackObjectiveConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case FOLLOW_OBJECTIVE: {
                MenuHandler.openFollowObjectiveConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case ADVANCED_DIALOG: {
                MenuHandler.openAdvancedDialogConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case ADVANCED_POSE: {
                MenuHandler.openAdvancedPoseConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case BASIC_ACTION: {
                MenuHandler.openBasicActionConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DIALOG_ACTION: {
                MenuHandler.openDialogActionConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DISTANCE_ACTION: {
                MenuHandler.openDistanceActionConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case BASIC_DIALOG: {
                MenuHandler.openBasicDialogConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case NONE_SKIN: {
                MenuHandler.openNoneSkinConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case CUSTOM_SKIN: {
                MenuHandler.openCustomSkinConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DEFAULT_SKIN: {
                MenuHandler.openDefaultSkinConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case EQUIPMENT: {
                MenuHandler.openEquipmentConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case MAIN: {
                MenuHandler.openMainConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DEFAULT_POSE: {
                MenuHandler.openDefaultPoseConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case CUSTOM_POSE: {
                MenuHandler.openCustomPoseConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DEFAULT_POSITION: {
                MenuHandler.openDefaultPositionConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DEFAULT_ROTATION: {
                MenuHandler.openDefaultRotationConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case NONE_DIALOG: {
                MenuHandler.openNoneDialogConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case PLAYER_SKIN: {
                MenuHandler.openPlayerSkinConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case URL_SKIN: {
                MenuHandler.openUrlSkinConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case SCALING: {
                MenuHandler.openScalingConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case YES_NO_DIALOG: {
                MenuHandler.openYesNoDialogConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case CUSTOM_PRESET_EXPORT: {
                MenuHandler.openCustomPresetExportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case WORLD_PRESET_EXPORT: {
                MenuHandler.openWorldPresetExportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case LOCAL_PRESET_IMPORT: {
                this.openLocalPresetImportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DEFAULT_PRESET_IMPORT: {
                MenuHandler.openDefaultPresetImportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case WORLD_PRESET_IMPORT: {
                MenuHandler.openServerPresetImportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case CUSTOM_PRESET_IMPORT: {
                MenuHandler.openCustomPresetImportConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case BASIC_TRADING: {
                MenuHandler.openBasicTradingConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case NONE_TRADING: {
                MenuHandler.openNoneTradingConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case ADVANCED_TRADING: {
                MenuHandler.openAdvancedTradingConfigurationMenu(serverPlayer, easyNPC, pageIndex);
                break;
            }
            case CUSTOM_TRADING: {
                MenuHandler.openCustomTradingConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case BASIC_OBJECTIVE: {
                MenuHandler.openBasicObjectiveConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case ABILITIES_ATTRIBUTE: {
                MenuHandler.openAbilitiesAttributeConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case BASE_ATTRIBUTE: {
                MenuHandler.openBaseAttributeConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case LOOK_OBJECTIVE: {
                MenuHandler.openLookObjectiveConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            case DISPLAY_ATTRIBUTE: {
                MenuHandler.openDisplayAttributeConfigurationMenu(serverPlayer, easyNPC);
                break;
            }
            default: {
                log.debug("Unknown dialog {} for {} from {}", (Object)configurationType, easyNPC, (Object)serverPlayer);
            }
        }
    }

    private void openLocalPresetImportConfigurationMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        if (MenuHandler.hasPermissions(serverPlayer, easyNPC, (Boolean)MenuHandler.COMMON.localImportPresetConfigurationEnabled.get(), (Boolean)MenuHandler.COMMON.localImportPresetConfigurationAllowInCreative.get(), (Integer)MenuHandler.COMMON.localImportPresetConfigurationPermissionLevel.get())) {
            UUID uuid = easyNPC.getUUID();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)LocalImportPresetConfigurationMenu.getMenuProvider(uuid, easyNPC.getEntity()), buffer -> buffer.m_130077_(uuid));
        }
    }

    @Override
    public void openDialogMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        this.openDialogMenu(serverPlayer, (MenuType)ModMenuTypes.DIALOG_MENU.get(), easyNPC, dialogId, pageIndex);
    }

    @Override
    public void openTestMenu(ServerPlayer serverPlayer, UUID npcUUID) {
        this.openTestMenu(serverPlayer, (MenuType)ModMenuTypes.TEST_MENU.get(), npcUUID);
    }
}

