/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.screen.ScreenContainerData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import de.markusbordihn.easynpc.menu.testing.TestMenu;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandlerInterface;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private static void syncServerSideData(UUID npcUUID, ServerPlayer serverPlayer) {
        ClientNetworkMessageHandlerInterface networkMessageHandler = NetworkMessageHandlerManager.getClientHandler();
        if (networkMessageHandler != null) {
            log.debug("Sync server side data for {}", (Object)serverPlayer);
            networkMessageHandler.syncActionEventSet(npcUUID, serverPlayer);
            networkMessageHandler.syncDialogDataSet(npcUUID, serverPlayer);
            networkMessageHandler.syncObjectiveDataSet(npcUUID, serverPlayer);
        }
    }

    private static void openEasyNpcMenu(ServerPlayer serverPlayer, MenuType<?> menuType, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        MenuHandlerInterface.openEasyNpcMenu(serverPlayer, menuType, easyNPC, dialogId, pageIndex, easyNPC.getEntity().m_7755_());
    }

    private static void openEasyNpcMenu(ServerPlayer serverPlayer, final MenuType<?> menuType, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex, Component menuName) {
        MenuHandlerInterface.syncServerSideData(easyNPC.getUUID(), serverPlayer);
        UUID npcUUID = easyNPC.getUUID();
        final Component displayName = menuName != null ? menuName : easyNPC.getEntity().m_7755_();
        final ScreenContainerData screenContainerData = new ScreenContainerData(npcUUID, dialogId, pageIndex);
        MenuProvider menuProvider = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new EasyNPCMenu(menuType, containerId, playerInventory, screenContainerData);
            }

            public Component m_5446_() {
                return displayName;
            }
        };
        serverPlayer.m_5893_(menuProvider);
    }

    public void openConfigurationMenu(ConfigurationType var1, ServerPlayer var2, EasyNPC<?> var3, int var4);

    public void openDialogEditorMenu(ServerPlayer var1, EasyNPC<?> var2, UUID var3, ConfigurationType var4, int var5);

    public void openDialogButtonEditorMenu(ServerPlayer var1, EasyNPC<?> var2, UUID var3, UUID var4, ConfigurationType var5, int var6);

    public void openDialogTextEditorMenu(ServerPlayer var1, EasyNPC<?> var2, UUID var3, ConfigurationType var4, int var5);

    default public void openConfigurationMenu(ConfigurationType configurationType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC) {
        this.openConfigurationMenu(configurationType, serverPlayer, easyNPC, 0);
    }

    public void openDialogMenu(ServerPlayer var1, EasyNPC<?> var2, UUID var3, int var4);

    default public void openDialogMenu(ServerPlayer serverPlayer, MenuType<?> menuType, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        MenuHandlerInterface.openEasyNpcMenu(serverPlayer, menuType, easyNPC, dialogId, pageIndex);
    }

    public void openTestMenu(ServerPlayer var1, UUID var2);

    default public void openTestMenu(final ServerPlayer serverPlayer, final MenuType<?> menuType, UUID npcUUID) {
        MenuHandlerInterface.syncServerSideData(npcUUID, serverPlayer);
        final ScreenContainerData screenContainerData = new ScreenContainerData(npcUUID, UUID.randomUUID());
        log.info("Open test menu for {}({}) and {}", (Object)npcUUID, (Object)screenContainerData.getNpcUUID(), (Object)screenContainerData.getDialogUUID());
        MenuProvider menuProvider = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new TestMenu(menuType, containerId, playerInventory, screenContainerData);
            }

            public Component m_5446_() {
                return serverPlayer.m_7755_();
            }
        };
        serverPlayer.m_5893_(menuProvider);
    }
}

